% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/od.3.R
\name{od.3}
\alias{od.3}
\title{Optimal sample allocation calculation for three-level CRTs detecting main effects}
\usage{
od.3(
  n = NULL,
  J = NULL,
  p = NULL,
  icc2 = NULL,
  icc3 = NULL,
  r12 = NULL,
  r22 = NULL,
  r32 = NULL,
  c1 = NULL,
  c2 = NULL,
  c3 = NULL,
  c1t = NULL,
  c2t = NULL,
  c3t = NULL,
  m = NULL,
  plots = TRUE,
  plot.by = NULL,
  nlim = NULL,
  Jlim = NULL,
  plim = NULL,
  varlim = NULL,
  nlab = NULL,
  Jlab = NULL,
  plab = NULL,
  varlab = NULL,
  vartitle = NULL,
  verbose = TRUE,
  iter = 100,
  tol = 1e-10
)
}
\arguments{
\item{n}{The level-1 sample size per level-2 unit.}

\item{J}{The level-2 sample size per level-3 unit.}

\item{p}{The proportion of level-3 clusters/units assigned to treatment.}

\item{icc2}{The unconditional intraclass correlation coefficient (ICC) at level 2.}

\item{icc3}{The unconditional intraclass correlation coefficient (ICC) at level 3.}

\item{r12}{The proportion of level-1 variance explained by covariates.}

\item{r22}{The proportion of level-2 variance explained by covariates.}

\item{r32}{The proportion of level-3 variance explained by covariates.}

\item{c1}{The cost of sampling one level-1 unit in control condition.}

\item{c2}{The cost of sampling one level-2 unit in control condition.}

\item{c3}{The cost of sampling one level-3 unit in control condition.}

\item{c1t}{The cost of sampling one level-1 unit in treatment condition.}

\item{c2t}{The cost of sampling one level-2 unit in treatment condition.}

\item{c3t}{The cost of sampling one level-3 unit in treatment condition.}

\item{m}{Total budget, default is the total costs of sampling 60
level-3 units across treatment conditions.}

\item{plots}{Logical, provide variance plots if TRUE, otherwise not; default value is TRUE.}

\item{plot.by}{Plot the variance by \code{n}, \code{J}
and/or \code{p}; default is plot.by = list(n = "n", J = "J", p = "p").}

\item{nlim}{The plot range for n, default value is c(2, 50).}

\item{Jlim}{The plot range for J, default value is c(2, 50).}

\item{plim}{The plot range for p, default value is c(0, 1).}

\item{varlim}{The plot range for variance, default value is c(0, 0.05).}

\item{nlab}{The plot label for \code{n},
default value is "Level-1 Sample Size: n".}

\item{Jlab}{The plot label for \code{J},
default value is "Level-2 Sample Size: J".}

\item{plab}{The plot label for p, default is "Proportion Level-3
Units in Treatment: p".}

\item{varlab}{The plot label for variance,
default value is "Variance".}

\item{vartitle}{The title of variance plot, default value is NULL.}

\item{verbose}{Logical; print the values of \code{n}, \code{J}, and \code{p} if TRUE,
otherwise not; default is TRUE.}

\item{iter}{Number of iterations; default value is 100.}

\item{tol}{Tolerance for convergence; default value is 1e-10.}
}
\value{
Unconstrained or constrained optimal sample allocation
    (\code{n}, \code{J}, and \code{p}).
    The function also returns the variance of the treatment effect,
    function name, design type,
    and parameters used in the calculation.
}
\description{
The optimal design of three-level
    cluster randomized trials (CRTs) is to calculate
    the optimal sample allocation that minimizes the variance of
    treatment effect under fixed budget, which is approximately the optimal
    sample allocation that maximizes statistical power under a fixed budget.
    The optimal design parameters include
    the level-1 sample size per level-2 unit (\code{n}),
    the level-2 sample size per level-3 unit (\code{J}),
    and the proportion of level-3 clusters/groups to be assigned to treatment (\code{p}).
    This function solves the optimal \code{n}, \code{J} and/or \code{p}
    with and without constraints.
}
\examples{
# Unconstrained optimal design #---------
  myod1 <- od.3(icc2 = 0.2, icc3 = 0.1, r12 = 0.5, r22 = 0.5, r32 = 0.5,
             c1 = 1, c2 = 5, c3 = 25, c1t = 1, c2t = 50, c3t = 250,
             varlim = c(0.005, 0.025))
  myod1$out # output
# Plots by p and J
  myod1 <- od.3(icc2 = 0.2, icc3 = 0.1, r12 = 0.5, r22 = 0.5, r32 = 0.5,
             c1 = 1, c2 = 5, c3 = 25, c1t = 1, c2t = 50, c3t = 250,
             varlim = c(0.005, 0.025), plot.by = list(p = 'p', J = 'J'))

# Constrained optimal design with J = 20 #---------
  myod2 <- od.3(icc2 = 0.2, icc3 = 0.1, r12 = 0.5, r22 = 0.5, r32 = 0.5, J = 20,
             c1 = 1, c2 = 5, c3 = 25, c1t = 1, c2t = 50, c3t = 250,
             varlim = c(0, 0.025))
  myod2$out
# Relative efficiency (RE)
  myre <- re(od = myod1, subod= myod2)
  myre$re # RE = 0.53

# Constrained optimal design with p = 0.5 #---------
  myod3 <- od.3(icc2 = 0.2, icc3 = 0.1, r12 = 0.5, r22 = 0.5, r32 = 0.5, p = 0.5,
             c1 = 1, c2 = 5, c3 = 25, c1t = 1, c2t = 50, c3t = 250,
             varlim = c(0.005, 0.025))
  myod3$out
# Relative efficiency (RE)
  myre <- re(od = myod1, subod= myod3)
  myre$re # RE = 0.84

# Constrained n, J and p, no calculation performed #---------
  myod4 <- od.3(icc2 = 0.2, icc3 = 0.1, r12 = 0.5, r22 = 0.5, r32 = 0.5, n = 10, J = 10, p = 0.5,
             c1 = 1, c2 = 5, c3 = 25, c1t = 1, c2t = 50, c3t = 250,
             varlim = c(0, 0.025))
  myod4$out
# Relative efficiency (RE)
  myre <- re(od = myod1, subod= myod4)
  myre$re # RE = 0.61

}
\references{
Shen, Z., & Kelcey, B. (2020).
  Optimal sample allocation under unequal costs in cluster-randomized trials.
  Journal of Educational and Behavioral Statistics, 45(4): 446–474.
  <https://doi.org/10.3102/1076998620912418>
}
