% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importFromMorse.R
\name{predict_ode}
\alias{predict_ode}
\alias{predict_ode.survFit}
\alias{predict_Nsurv_ode}
\alias{predict_Nsurv_ode.survFit}
\title{Predict method for \code{survFit} objects}
\usage{
predict_ode(object, ...)

\method{predict_ode}{survFit}(
  object,
  data_predict = NULL,
  spaghetti = FALSE,
  mcmc_size = 1000,
  hb_value = TRUE,
  interpolate_length = 100,
  interpolate_method = "linear",
  hb_valueFORCED = NA,
  ...
)

predict_Nsurv_ode(
  object,
  data_predict,
  spaghetti,
  mcmc_size,
  hb_value,
  hb_valueFORCED,
  extend_time,
  interpolate_length,
  interpolate_method,
  ...
)

\method{predict_Nsurv_ode}{survFit}(
  object,
  data_predict = NULL,
  spaghetti = FALSE,
  mcmc_size = 1000,
  hb_value = FALSE,
  hb_valueFORCED = 0,
  extend_time = 100,
  interpolate_length = NULL,
  interpolate_method = "linear",
  ...
)
}
\arguments{
\item{object}{An object of class \code{survFit}.}

\item{\dots}{Further arguments to be passed to generic methods}

\item{data_predict}{A dataframe with three columns \code{time}, \code{conc} and \code{replicate}
used for prediction. If \code{NULL}, prediction is based on \code{x} object of
class \code{survFit} used for fitting.}

\item{spaghetti}{If \code{TRUE}, return a set of survival curves using
parameters drawn from the posterior distribution.}

\item{mcmc_size}{Can be used to reduce the number of mcmc samples in order to speed up
the computation. \code{mcmc_size} is the number of selected iterations for one chain. Default
is 1000. If all MCMC is wanted, set argument to \code{NULL}.}

\item{hb_value}{If \code{TRUE}, the background mortality \code{hb} is taken into account from the posterior.
If \code{FALSE}, parameter \code{hb} is set to 0. The default is \code{TRUE}.}

\item{interpolate_length}{Length of the time sequence for which output is wanted.}

\item{interpolate_method}{The interpolation method for concentration. See package \code{deSolve} for details.
Default is \code{linear}.}

\item{hb_valueFORCED}{If \code{hb_value} is \code{FALSE}, it fix \code{hb}.}

\item{extend_time}{Length of time points interpolated with variable exposure profiles.}
}
\value{
The function returns an object of class \code{survFitPredict} or
\code{survFitPredict_Nsurv} with two items:
\item{df_quantile}{Predicted quantiles (q50, qinf95, and qsup95)}
\item{df_spaghetti}{Predicted survival curve (if spaghetti = \code{TRUE})}
}
\description{
Function from the \code{morse v 3.3.1} package.
This is a \code{method} to replace function \code{predict} used on \code{survFit}
object when computing issues happen. \code{predict_ode} uses the \code{deSolve}
library to improve robustness. However, time to compute may be longer.

Function from the \code{morse v 3.3.1} package.
This is the generic \code{predict} S3 method for the \code{survFit} class.
It provides predicted survival rate for "SD" or "IT" models under constant or time-variable exposure.

Function from the \code{morse v 3.3.1} package.
This is a \code{method} to replace function \code{predict_Nsurv} used on \code{survFit}
object when computing issues happen. \code{predict_nsurv_ode} uses the \code{deSolve}
library to improve robustness. However, time to compute may be longer.
}
\examples{
library("odeGUTS")
data(fit_odeGUTS)

data_4prediction <- data.frame(time = 1:10,
                               conc = c(0,5,30,30,0,0,5,30,15,0),
                               replicate= rep("predict", 10))

predict_out <- predict_ode(object = fit_odeGUTS, data_predict = data_4prediction,
                           mcmc_size = 200, spaghetti = FALSE)



}
