% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/driver-oracle.R
\docType{class}
\name{Oracle-class}
\alias{Oracle-class}
\alias{sqlCreateTable,Oracle-method}
\alias{odbcConnectionTables,Oracle,character-method}
\alias{odbcConnectionColumns,Oracle,character-method}
\title{Oracle}
\usage{
\S4method{sqlCreateTable}{Oracle}(
  con,
  table,
  fields,
  row.names = NA,
  temporary = FALSE,
  ...,
  field.types = NULL
)

\S4method{odbcConnectionTables}{Oracle,character}(
  conn,
  name,
  catalog_name = NULL,
  schema_name = NULL,
  table_type = NULL,
  exact = FALSE
)

\S4method{odbcConnectionColumns}{Oracle,character}(
  conn,
  name,
  catalog_name = NULL,
  schema_name = NULL,
  column_name = NULL,
  exact = FALSE
)
}
\description{
Details of Oracle methods for odbc and DBI generics.

\subsection{\code{odbcConnectionTables()}}{

Query, rather than use \code{SQLTables} ODBC API for performance reasons.
Main functional difference between the implementation of \code{SQLTables} in the
OEM driver and the query below is that the OEM implementation also looks
through the synonyms. Given the performance reports, we sacrifice the
synonym look-through for better execution time.
}

\subsection{\code{odbcConnectionColumns()}}{

Query, rather than use \code{SQLColumns} ODBC API, since we bind a \code{BIGINT} to
one of the column results and Oracle's OEM driver can't handle it.
}
}
\keyword{internal}
