% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coastlineWorldMedium.R
\docType{data}
\name{coastlineWorldMedium}
\alias{coastlineWorldMedium}
\title{World coastline at medium-scale (1:50M) resolution}
\usage{
data(coastlineWorldMedium, package="ocedata")
}
\description{
\code{coastlineWorldMedum} is analogous to \code{coastlineWorld} in the \CRANpkg{oce}
package, but at higher resolution, i.e. showing more detail.  It is suitable
for basin-scale plots; for sub-basin work, try \code{\link{coastlineWorldFine}}.
}
\details{
The data for \code{coastlineWorldMedium} were downloaded from shapefile
\code{ne_50m_admin_0_countries.shp}, stored at
\url{https://www.naturalearthdata.com}.

The documentation for \code{coastline-class} in \CRANpkg{oce} explains the
structure of coastline objects and discusses functions that deal with them.
}
\examples{
# Regional plot of the Maritime provinces of Canada.
data(coastlineWorldMedium, package="ocedata")
\dontrun{
library(oce)
plot(coastlineWorldMedium, clongitude=-63, clatitude=45.5, span=600)
}
}
\seealso{
Other coastline files: 
\code{\link{coastlineWorldFine}}
}
\concept{coastline files}
