% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cm.R
\name{applyMagneticDeclination,cm-method}
\alias{applyMagneticDeclination,cm-method}
\title{Alter a cm Object to Account for Magnetic Declination}
\usage{
\S4method{applyMagneticDeclination}{cm}(
  object = "oce",
  declination = 0,
  debug = getOption("oceDebug")
)
}
\arguments{
\item{object}{a \linkS4class{cm} object.}

\item{declination}{numeric value holding magnetic declination in degrees,
positive for clockwise from north.}

\item{debug}{an integer specifying whether debugging information is
to be printed during the processing. This is a general parameter that
is used by many \code{oce} functions. Generally, setting \code{debug=0}
turns off the printing, while higher values suggest that more information
be printed. If one function calls another, it usually reduces the value of
\code{debug} first, so that a user can often obtain deeper debugging
by specifying higher \code{debug} values.}
}
\value{
A \linkS4class{cm} object, adjusted as outlined in \dQuote{Details}.
}
\description{
Current-meter (\code{cm}) instruments determine directions from onboard compasses,
so interpreting velocity components in geographical coordinates requires that
magnetic declination be taken into account.  This is what the present
function does (see \dQuote{Details}).
}
\details{
The returned value is a copy of \code{object} that has been modified in 4 ways.
(1) the horizontal components of velocity are rotated clockwise by
\code{declination} degrees.  (2) If the object holds heading values, then
\code{declination} is added to them. (3) The \code{north} item in the \code{metadata} slot
is set to \code{"geographic"}, and a warning is issued if this was also the value
in \code{object}.  (4) The \code{declination} item in the \code{metadata} slot is set to
the value supplied to this function.
}
\seealso{
Use \code{\link[=magneticField]{magneticField()}} to determine the declination,
inclination and intensity at a given spot on the world, at a given time.

Other things related to magnetism: 
\code{\link{applyMagneticDeclination,adp-method}},
\code{\link{applyMagneticDeclination,adv-method}},
\code{\link{applyMagneticDeclination,oce-method}},
\code{\link{applyMagneticDeclination}()},
\code{\link{magneticField}()}

Other things related to cm data: 
\code{\link{[[,cm-method}},
\code{\link{[[<-,cm-method}},
\code{\link{as.cm}()},
\code{\link{cm-class}},
\code{\link{cm}},
\code{\link{plot,cm-method}},
\code{\link{read.cm}()},
\code{\link{rotateAboutZ}()},
\code{\link{subset,cm-method}},
\code{\link{summary,cm-method}}
}
\author{
Dan Kelley
}
\concept{things related to cm data}
\concept{things related to magnetism}
