% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{snakeToCamel}
\alias{snakeToCamel}
\title{Convert each of a vector of strings from SNAKE_CASE to camelCase}
\usage{
snakeToCamel(s, specialCases = NULL)
}
\arguments{
\item{s}{A vector of character values.}

\item{specialCases}{A vector of character values that tell which
special-cases to apply, or \code{NULL} (the default) to turn off special
cases.  The only permitted special case at the moment is \code{"QC"} (see
\dQuote{Details}) but the idea of this argument is that other cases
can be added later, if needed.}
}
\value{
A vector of character values
}
\description{
\code{snakeToCamel} converts "snake-case" characters such as \code{"NOVA_SCOTIA"}
to "camel-case" values, such as \code{"NovaScotia"}.  It was written for
use by \code{\link[=read.argo]{read.argo()}}, but it also may prove helpful in other contexts.
}
\details{
The basic procedure is to chop the string up into substrings separated by
the underline character, then to upper-case the first letter of
all substrings except the first, and then to paste the substrings
together.

However, there are exceptions.  First, any upper-case string that contains no
underlines is converted to lower case, but any mixed-case string with no
underlines is returned as-is (see the second example). Second, if
the \code{specialCases} argument contains \code{"QC"}, then the
\code{QC} is passed through directly (since it is an acronym) and
if the first letter of remaining text is upper-cased (contrast
see the four examples).
}
\examples{
library(oce)
snakeToCamel("PARAMETER_DATA_MODE")   # "parameterDataMode"
snakeToCamel("PARAMETER")             # "parameter"
snakeToCamel("HISTORY_QCTEST")        # "historyQctest"
snakeToCamel("HISTORY_QCTEST", "QC")  # "historyQCTest"
snakeToCamel("PROFILE_DOXY_QC")       # "profileDoxyQc"
snakeToCamel("PROFILE_DOXY_QC", "QC") # "profileDoxyQC"
}
\author{
Dan Kelley
}
