% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adp.R
\name{read.adp}
\alias{read.adp}
\title{Read an ADP File}
\usage{
read.adp(
  file,
  from,
  to,
  by,
  tz = getOption("oceTz"),
  longitude = NA,
  latitude = NA,
  manufacturer,
  monitor = FALSE,
  despike = FALSE,
  processingLog,
  debug = getOption("oceDebug"),
  ...
)
}
\arguments{
\item{file}{a connection or a character string giving the name of the file
to load.  (For \code{read.adp.sontek.serial}, this is generally a list of
files, which will be concatenated.)}

\item{from}{indication of the first profile to read.  This can be an
integer, the sequence number of the first profile to read, or a POSIXt time
before which profiles should be skipped, or a character string that converts
to a POSIXt time (assuming UTC timezone).  See \dQuote{Examples}, and make
careful note of the use of the \code{tz} argument. If \code{from} is not
supplied, it defaults to 1.}

\item{to}{an optional indication of the last profile to read, in a
format as described for \code{from}.  As a special case, \code{to=0} means
to read the file to the end.  If \code{to} is not supplied, then it defaults
to 0.}

\item{by}{an optional indication of the stride length to use while walking through
the file.  If this is an integer, then \code{by-1} profiles are skipped
between each pair of profiles that is read, e.g. the default \code{by=1}
means to read all the data.  (For RDI files \emph{only}, there are some
extra features to avoid running out of memory; see \dQuote{Memory considerations}.)}

\item{tz}{character string indicating time zone to be assumed in the data.}

\item{longitude}{optional signed number indicating the longitude in degrees
East.}

\item{latitude}{optional signed number indicating the latitude in degrees
North.}

\item{manufacturer}{an optional character string indicating the manufacturer, used by
the general function \code{read.adp} to select a subsidiary function to use. If this
is not given, then \code{\link[=oceMagic]{oceMagic()}} is used to try to infer the type. If this
is provided, then the value \code{"rdi"} will cause \code{\link[=read.adp.rdi]{read.adp.rdi()}}
to be used, \code{"nortek"} will cause \code{\link[=read.adp.nortek]{read.adp.nortek()}} to be used,
and \code{"sontek"} will cause \code{\link[=read.adp.sontek]{read.adp.sontek()}} to be used.}

\item{monitor}{boolean, set to \code{TRUE} to provide an indication of progress
in reading the file, either by printing a dot for each profile or by writing
a textual progress bar with \code{\link[=txtProgressBar]{txtProgressBar()}}.}

\item{despike}{if \code{TRUE}, \code{\link[=despike]{despike()}} will be used to clean
anomalous spikes in heading, etc.}

\item{processingLog}{if provided, the action item to be stored in the log.
(Typically only provided for internal calls; the default that it provides is
better for normal calls by a user.)}

\item{debug}{a flag that turns on debugging.  Set to 1 to get a moderate
amount of debugging information, or to 2 to get more.}

\item{\dots}{optional additional arguments that some (but not all)
\verb{read.adp.*()} functions pass to lower-level functions.}
}
\value{
An \linkS4class{adp} object.
The contents of that object make sense for the particular instrument
type under study, e.g. if the data file contains
NMEA strings, then navigational data will be stored in an item
called \code{nmea} in the \code{data} slot).
}
\description{
Read an ADP data file, producing an \linkS4class{adp} object.
}
\details{
Several file types can be handled.  Some of
these functions are wrappers that map to device names, e.g.
\code{read.aquadoppProfiler} does its work by calling
\code{read.adp.nortek}; in this context, it is worth noting that the
``aquadopp'' instrument is a one-cell profiler that might just as well have
been documented under the heading \code{\link[=read.adv]{read.adv()}}.
}
\seealso{
Other things related to adp data: 
\code{\link{[[,adp-method}},
\code{\link{[[<-,adp-method}},
\code{\link{ad2cpHeaderValue}()},
\code{\link{adp-class}},
\code{\link{adpEnsembleAverage}()},
\code{\link{adp_rdi.000}},
\code{\link{adp}},
\code{\link{as.adp}()},
\code{\link{beamName}()},
\code{\link{beamToXyzAdpAD2CP}()},
\code{\link{beamToXyzAdp}()},
\code{\link{beamToXyzAdv}()},
\code{\link{beamToXyz}()},
\code{\link{beamUnspreadAdp}()},
\code{\link{binmapAdp}()},
\code{\link{enuToOtherAdp}()},
\code{\link{enuToOther}()},
\code{\link{handleFlags,adp-method}},
\code{\link{is.ad2cp}()},
\code{\link{plot,adp-method}},
\code{\link{read.adp.ad2cp}()},
\code{\link{read.adp.nortek}()},
\code{\link{read.adp.rdi}()},
\code{\link{read.adp.sontek.serial}()},
\code{\link{read.adp.sontek}()},
\code{\link{read.aquadoppHR}()},
\code{\link{read.aquadoppProfiler}()},
\code{\link{read.aquadopp}()},
\code{\link{rotateAboutZ}()},
\code{\link{setFlags,adp-method}},
\code{\link{subset,adp-method}},
\code{\link{subtractBottomVelocity}()},
\code{\link{summary,adp-method}},
\code{\link{toEnuAdp}()},
\code{\link{toEnu}()},
\code{\link{velocityStatistics}()},
\code{\link{xyzToEnuAdpAD2CP}()},
\code{\link{xyzToEnuAdp}()},
\code{\link{xyzToEnu}()}
}
\author{
Dan Kelley and Clark Richards
}
\concept{things related to adp data}
