% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adv.R
\name{enuToOtherAdv}
\alias{enuToOtherAdv}
\title{Convert ENU to Other Coordinate}
\usage{
enuToOtherAdv(x, heading = 0, pitch = 0, roll = 0,
  debug = getOption("oceDebug"))
}
\arguments{
\item{x}{An \code{adv} object, i.e. one inheriting from \code{\link{adv-class}}.}

\item{heading}{number or vector of numbers, giving the angle, in degrees, to
be added to the heading. If this has length less than the number of velocity
sampling times, then it will be extended using \code{\link{rep}}.}

\item{pitch}{as \code{heading} but for pitch.}

\item{roll}{as \code{heading} but for roll.}

\item{debug}{an integer specifying whether debugging information is
to be printed during the processing. This is a general parameter that
is used by many \code{oce} functions. Generally, setting \code{debug=0}
turns off the printing, while higher values suggest that more information
be printed. If one function calls another, it usually reduces the value of
\code{debug} first, so that a user can often obtain deeper debugging
by specifying higher \code{debug} values.}
}
\description{
Convert ADV velocity components from an enu-based coordinate system to
another system, perhaps to align axes with the coastline.
}
\details{
The supplied angles specify rotations to be made around the axes for which
heading, pitch, and roll are defined.  For example, an eastward current will
point southeast if \code{heading=45} is used.

The returned value has heading, pitch, and roll matching those of \code{x},
so these angles retain their meaning as the instrument orientation.

NOTE: this function works similarly to \code{\link{xyzToEnuAdv}}, except
that in the present function, it makes no difference whether the instrument
points up or down, etc.
}
\seealso{
Other things related to adv data: \code{\link{[[,adv-method}},
  \code{\link{[[<-,adv-method}}, \code{\link{adv-class}},
  \code{\link{adv}}, \code{\link{beamName}},
  \code{\link{beamToXyz}}, \code{\link{enuToOther}},
  \code{\link{plot,adv-method}},
  \code{\link{read.adv.nortek}},
  \code{\link{read.adv.sontek.adr}},
  \code{\link{read.adv.sontek.serial}},
  \code{\link{read.adv.sontek.text}},
  \code{\link{read.adv}}, \code{\link{rotateAboutZ}},
  \code{\link{subset,adv-method}},
  \code{\link{summary,adv-method}}, \code{\link{toEnuAdv}},
  \code{\link{toEnu}}, \code{\link{velocityStatistics}},
  \code{\link{xyzToEnuAdv}}, \code{\link{xyzToEnu}}
}
\author{
Dan Kelley
}
\concept{things related to adv data}
