% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amsr.R
\name{download.amsr}
\alias{download.amsr}
\title{Download and Cache an amsr File}
\usage{
download.amsr(year, month, day, destdir = ".",
  server = "ftp.ssmi.com/amsr2/bmaps_v07.2")
}
\arguments{
\item{year, month, day}{Numerical values of the year, month, and day
of the desired dataset. Note that one file is archived per day, 
so these three values uniquely identify a dataset.
If \code{day} and \code{month} are not provided but \code{day} is,
then the time is provided in a relative sense, based on the present
date, with \code{day} indicating the number of days in the past.
Owing to issues with timezones and the time when the data
are uploaded to the server, \code{day=3} may yield the
most recent available data. For this reason, there is a 
third option, which is to leave \code{day} unspecified, which
works as though \code{day=3} had been given.}

\item{destdir}{String naming the directory in which to cache resultant files.}

\item{server}{String naming the server from which data are to be acquired.}
}
\value{
A character value indicating the filename of the result; if
there is a problem of any kind, the result will be the empty
string.
}
\description{
If the file is already present in \code{destdir}, then it is not
downloaded again. The default \code{destdir} is the present directory,
but it probably makes more sense to use something like \code{"~/data/amsr"}
to make it easy for scripts in other directories to use the cached data.
}
\details{
This function relies on the system utility \code{ftp}, and also on local directories
being separated by forward slashes in the file system. That means it will probably
only work on unix-like systems.
}
\section{Warning}{

All of the \code{download.*} functions are subject to change through the
autumn of 2016. The plan is to create individual functions
as needs arise in everyday work, thereby discovering patterns of 
arguments that might make sense more generally. Therefore, it is likely
that argument order (and even name) may change up until approximately
December 2016. Users are advised to refer to arguments by name,
i.e. not to rely on their order, and they are asked for patience,
because argument names and defaults may vary through the early development.
}
\seealso{
Other functions that download files: \code{\link{download.coastline}},
  \code{\link{download.topo}}

Other things related to \code{amsr} data: \code{\link{[[<-,amsr-method}},
  \code{\link{amsr-class}},
  \code{\link{composite,amsr-method}},
  \code{\link{plot,amsr-method}}, \code{\link{read.amsr}},
  \code{\link{subset,amsr-method}},
  \code{\link{summary,amsr-method}}
}

