% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidem.R
\docType{methods}
\name{plot,tidem-method}
\alias{plot,tidem-method}
\title{Plot a Tidem Prediction}
\usage{
\S4method{plot}{tidem}(x, which = 1, labelIf = NULL, log = "",
  mgp = getOption("oceMgp"), mar = c(mgp[1] + 1, mgp[1] + 1, mgp[2] + 0.25,
  mgp[2] + 1), ...)
}
\arguments{
\item{x}{A \code{tidem} object, i.e. one inheriting from
\code{\link{tidem-class}}.}

\item{which}{integer flag indicating plot type, 1 for stair-case spectral, 2
for spike spectral.}

\item{labelIf}{if NULL, the function will indicate some particular tidal
constituents; if a value is provided, labels will be given for any
constituent with amplitude exceeding the value provided.}

\item{log}{if set to "\code{x}", the frequency axis will be logarithmic.}

\item{mgp}{3-element numerical vector to use for \code{par(mgp)}, and also
for \code{par(mar)}, computed from this.  The default is tighter than the R
default, in order to use more space for the data and less for the axes.}

\item{mar}{value to be used with \code{\link{par}("mar")}.}

\item{\dots}{optional arguments passed to plotting functions.}
}
\description{
Plot a summary diagram for a tidal fit.
}
\examples{
\dontrun{
library(oce)
data(sealevel)
tide <- tidem(sealevel)
plot(tide)
}
}
\author{
Dan Kelley
}
\seealso{
Other functions that plot \code{oce} data: \code{\link{plot,adp-method}},
  \code{\link{plot,adv-method}},
  \code{\link{plot,amsr-method}},
  \code{\link{plot,argo-method}},
  \code{\link{plot,bremen-method}},
  \code{\link{plot,cm-method}},
  \code{\link{plot,coastline-method}},
  \code{\link{plot,ctd-method}},
  \code{\link{plot,gps-method}},
  \code{\link{plot,ladp-method}},
  \code{\link{plot,lisst-method}},
  \code{\link{plot,lobo-method}},
  \code{\link{plot,met-method}},
  \code{\link{plot,odf-method}},
  \code{\link{plot,rsk-method}},
  \code{\link{plot,satellite-method}},
  \code{\link{plot,sealevel-method}},
  \code{\link{plot,section-method}},
  \code{\link{plot,topo-method}},
  \code{\link{plot,windrose-method}},
  \code{\link{plotProfile}}, \code{\link{plotScan}},
  \code{\link{plotTS}}, \code{\link{tidem-class}}

Other things related to \code{tidem} data: \code{\link{[[,tidem-method}},
  \code{\link{[[<-,tidem-method}},
  \code{\link{predict.tidem}},
  \code{\link{summary,tidem-method}},
  \code{\link{tidedata}}, \code{\link{tidem-class}},
  \code{\link{tidemAstron}}, \code{\link{tidemVuf}},
  \code{\link{tidem}}
}

