% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cm.R
\docType{methods}
\name{plot,cm-method}
\alias{plot,cm-method}
\title{Plot CM data}
\usage{
\S4method{plot}{cm}(x, which = c(1:2, 7:9), type = "l", adorn = NULL,
  drawTimeRange = getOption("oceDrawTimeRange"), drawZeroLine = FALSE,
  mgp = getOption("oceMgp"), mar = c(mgp[1] + 1.5, mgp[1] + 1.5, 1.5, 1.5),
  small = 2000, main = "", tformat, debug = getOption("oceDebug"), ...)
}
\arguments{
\item{x}{an \code{cm} object, e.g. as read by \code{\link{read.cm}}.}

\item{which}{list of desired plot types.  These are graphed in panels running
down from the top of the page.  See \dQuote{Details} for the meanings of various
values of \code{which}.}

\item{type}{type of plot, as for \code{\link{plot}}.}

\item{adorn}{(\strong{Defunct})
An \code{\link{expression}} or vector of expressions that contain
R code that is to be executed immediately after each panel of the plot.
If the number of expressions matches the number of panels, then the 
expressions are used for the corresponding panels; otherwise, the
expression list is extended to match the number of panels (i.e.
to obtain \code{length(which)} elements). Note that \code{adorn}
is a dangerous argument, because if the expressions contained
therein set up local storage, there is a chance of entirely
disrupting the plotting. \strong{For this reason, \code{adorn} was
marked as defunct in June 2016, and will be removed entirely 
after the July CRAN release.} Users with existing code that uses
\code{adorn} should simply plot the panels individually, and
use conventional R functions, e.g. \code{\link{lines}} etc.,
after each panel, to achieve the desired effect.  (See
\code{\link{oce-defunct}} for notes on other deprecated or
defunct \code{oce} features.)}

\item{drawTimeRange}{boolean that applies to panels with time as the horizontal
axis, indicating whether to draw the time range in the top-left margin of the
plot.}

\item{drawZeroLine}{boolean that indicates whether to draw zero lines on
velocities.}

\item{mgp}{3-element numerical vector to use for \code{par(mgp)}, and also for
\code{par(mar)}, computed from this.  The default is tighter than the R default,
in order to use more space for the data and less for the axes.}

\item{mar}{value to be used with \code{\link{par}("mar")}.}

\item{small}{an integer indicating the size of data set to be considered
"small", to be plotted with points or lines using the standard
\code{\link{plot}} function.  Data sets with more than \code{small} points will
be plotted with \code{\link{smoothScatter}} instead.}

\item{main}{main title for plot, used just on the top panel, if there are
several panels.}

\item{tformat}{optional argument passed to \code{\link{oce.plot.ts}}, for plot
types that call that function.  (See \code{\link{strptime}} for the format
used.)}

\item{debug}{a flag that turns on debugging.  Set to 1 to get a moderate amount
of debugging information, or to 2 to get more.}

\item{...}{Optional arguments passed to plotting functions.}
}
\description{
Creates a multi-panel summary plot of data measured by a current meter.
}
\details{
The panels are controlled by the \code{which} argument, as follows.

\itemize{

\item \code{which=1} or \code{which="u"} for a time-series graph of eastward
  velocity, \code{u}, as a function of time.

\item \code{which=2} or \code{which="v"} for a time-series graph of
  northward velocity, \code{u}, as a function of time.

\item \code{which=3} or \code{"progressive vector"} for progressive-vector
  plot

\item \code{which=4} or \code{"uv"} for a plot of \code{v} versus \code{u}.
  (Dots are used for small datasets, and smoothScatter for large ones.)

\item \code{which=5} or \code{"uv+ellipse"} as the \code{"uv"} case, but
  with an added indication of the tidal ellipse, calculated from the eigen
  vectors of the covariance matrix.

\item \code{which=6} or \code{"uv+ellipse+arrow"} as the \code{"uv+ellipse"}
  case, but with an added arrow indicating the mean current.

\item \code{which=7} or \code{"pressure"} for pressure

\item \code{which=8} or \code{"salinity"} for salinity

\item \code{which=9} or \code{"temperature"} for temperature

\item \code{which=10} or \code{"TS"} for a TS diagram

\item \code{which=11} or \code{"conductivity"} for conductivity

\item \code{which=20} or \code{"heading"} for compass heading

}
}
\examples{
  library(oce)
  data(cm)
  summary(cm)
  plot(cm)

}
\author{
Dan Kelley
}
\seealso{
Other functions that plot \code{oce} data: \code{\link{plot,adp-method}},
  \code{\link{plot,adv-method}},
  \code{\link{plot,amsr-method}},
  \code{\link{plot,argo-method}},
  \code{\link{plot,bremen-method}},
  \code{\link{plot,coastline-method}},
  \code{\link{plot,ctd-method}},
  \code{\link{plot,gps-method}},
  \code{\link{plot,ladp-method}},
  \code{\link{plot,lisst-method}},
  \code{\link{plot,lobo-method}},
  \code{\link{plot,met-method}},
  \code{\link{plot,odf-method}},
  \code{\link{plot,rsk-method}},
  \code{\link{plot,satellite-method}},
  \code{\link{plot,sealevel-method}},
  \code{\link{plot,section-method}},
  \code{\link{plot,tidem-method}},
  \code{\link{plot,topo-method}},
  \code{\link{plot,windrose-method}},
  \code{\link{plotProfile}}, \code{\link{plotScan}},
  \code{\link{plotTS}}, \code{\link{tidem-class}}

Other things related to \code{cm} data: \code{\link{[[,cm-method}},
  \code{\link{[[<-,cm-method}}, \code{\link{cm-class}},
  \code{\link{cm}}, \code{\link{read.cm}},
  \code{\link{subset,cm-method}},
  \code{\link{summary,cm-method}}
}

