% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app_settings.R
\name{create_app_settings}
\alias{create_app_settings}
\title{Create app_settings.}
\usage{
create_app_settings(
  save_to_file,
  suggestion_type = "auxco-1.2.x",
  default_num_suggestions = 5,
  require_respondent_id = FALSE,
  warn_before_leaving = FALSE,
  skip_followup_types = c(),
  response_output_dir = file.path("output", "responses"),
  handle_data = NULL,
  get_job_suggestion_params = NULL,
  display_page_ids = TRUE,
  default_tense = "present",
  default_extra_instructions = "on",
  verbose = TRUE,
  .validate = TRUE
)
}
\arguments{
\item{save_to_file}{Should responses be saved as files in
response_output_dir? Defaults to use the SAVE_TO_FILE environment variable.
We recommend setting this to TRUE.}

\item{suggestion_type}{Which type of suggestion to use / provide.
Possible options are "auxco-1.2.x" and "kldb-2010".}

\item{default_num_suggestions}{The number of suggestions to generate and
display to users. Accepts all positive integers.
Defaults to 5.}

\item{require_respondent_id}{Are respondent_ids required?
Defaults to FALSE}

\item{warn_before_leaving}{Should users be warned that their progress will
be lost upon leaving the site? Defaults to FALSE.}

\item{skip_followup_types}{A vector of strings corresponding to the
question_type of followup_question that should be skipped. Allowed `
values: c("anforderungsniveau", "aufsicht", "spezialisierung", "sonstige")}

\item{response_output_dir}{Path to the directory in which to store data
from the app. Defaults to \verb{./output/responses/}.}

\item{handle_data}{Callback function to handle data from the app.
This setting takes a function that get's passed 3 parameters:
table_name (A reference name indicating which data to save),
data (A dataframe of data to save), session (the user's current session).}

\item{get_job_suggestion_params}{List of parameters to pass to
get_job_suggestion. Refer to \code{\link[=get_job_suggestions]{get_job_suggestions()}} for a list of
supported parameters. Note that the parameter aggregate_score_threshold
needs to be set on \code{\link[=page_first_freetext]{page_first_freetext()}} or \code{\link[=page_second_freetext]{page_second_freetext()}}.}

\item{display_page_ids}{Whether \code{page_ids} should be displayed within the
questionnaires.}

\item{default_tense}{We may not always want to ask for the current
occupation, but maybe also for the previous occupation in case of
pensioners etc. with a value of "past".
Possible values are "present" (default), "past".
This setting can be overwritten on a session-by-session basis with the
URL-Query parameter "tense".}

\item{default_extra_instructions}{Display additional instructions for e.g.
an interviewer conducting an interview.
Possible values are "on" (default), "off".
This setting can be overwritten on a session-by-session basis with the
URL-Query parameter "extra_instructions".}

\item{verbose}{Should additional output be printed when running?
Defaults to TRUE.}

\item{.validate}{Whether the created app_settings should be validated.
Defaults to TRUE.}
}
\value{
A list of app_settings.
}
\description{
This is the primary and most convenient way of configuring the app.
}
\examples{
\dontshow{data.table::setDTthreads(1)}

app_settings <- create_app_settings(
  # Important to save results from the app
  save_to_file = TRUE,
  require_respondent_id = TRUE
)
}
