% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/suggestions.R
\name{get_followup_questions}
\alias{get_followup_questions}
\title{Get potential follow-up questions for a suggestion.}
\usage{
get_followup_questions(
  suggestion_id,
  tense = "present",
  suggestion_type = "auxco-1.2.x",
  suggestion_type_options = list(),
  include_answer_codes = FALSE
)
}
\arguments{
\item{suggestion_id}{Id of the suggestion}

\item{tense}{Which tense i.e. time to use for questions & answers,
this can be "present" or "past". Defaults to "present".}

\item{suggestion_type}{Which suggestion type is being used.
Only auxco-based suggestion_types are supported.}

\item{suggestion_type_options}{A list with options for generating
suggestions. Supported options:
- \code{datasets}: Pass specific datasets to be used whenn adding information
to predictions e.g. use a specific version of the kldb or auxco.
Supported datasets are: "auxco-1.2.x", "kldb-2010". By default the datasets
bundled with this package are used.}

\item{include_answer_codes}{Whether answer options should contain
information on the associated codes. Defaults to FALSE.
(Only for internal use, use \code{\link[=get_final_codes]{get_final_codes()}} to get codes)}
}
\value{
List of followup questions and their answer options.
}
\description{
Get potential follow-up questions for a suggestion.
}
\examples{
# Get followup questions for "Post- und Zustelldienste"
get_followup_questions("1004")
}
