% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partial_dependence_plot.R
\name{pdplot}
\alias{pdplot}
\title{Plot partial variable dependence using an oblique random survival forest}
\usage{
pdplot(object, xvar, xlab = NULL, xvar_units = NULL, xvals = NULL,
  nxpts = 10, ytype = "nonevent", event_lab = "death",
  nonevent_lab = "survival", fvar = NULL, flab = NULL,
  flvls = NULL, time_units = "years", xlvls = NULL,
  sub_times = NULL, separate_panels = TRUE, color_palette = "Dark2")
}
\arguments{
\item{object}{an ORSF object (i.e. object returned from the ORSF function)}

\item{xvar}{a string giving the name of the x-axis variable}

\item{xlab}{the label to be printed describing the x-axis variable}

\item{xvar_units}{the unit of measurement for the x-axis variable. For example, age is usually measured in years.}

\item{xvals}{a vector containing the values that partial dependence will be computed with.}

\item{nxpts}{instead of specifying xvals, you can specify how many points on the x-axis you would like to plot predicted responses for, and a set of nxpts equally spaced percentile values from the distribution of xvar will be used.}

\item{ytype}{String. Use 'event' if you would like to plot the probability of the event, and  'nonevent' if you prefer to plot the probability of a non-event.}

\item{event_lab}{string that describes the event}

\item{nonevent_lab}{string that describes a non-event.}

\item{fvar}{a string indicating a variable to facet the plot with}

\item{flab}{a label describing the facet variable.}

\item{flvls}{the labels to be printed describing the facet variable. For a facet variable with k categories, flab should be a vector with k labels, given in the same order as the levels of the facet variable.}

\item{time_units}{the unit of time, e.g. days, since baseline.}

\item{xlvls}{A character vector with descriptions of each category in the x-variable. This is only relevant if x is categorical.}

\item{sub_times}{a vector of times to compute predicted survival probabilities. Note that the eval_times from the ORSF object are used to compute predictions, and sub_times must be a subset of those times.}

\item{separate_panels}{true or false. If true, the plot will display predictions in two separate panels, determined by the facet variable.}

\item{color_palette}{Palette to use for colors in the figure. Options are Diverging (BrBG, PiYG, PRGn, PuOr, RdBu, RdGy, RdYlBu, RdYlGn, Spectral), Qualitative (Accent, Dark2, Paired, Pastel1, Pastel2, Set1, Set2, Set3), Sequential (Blues, BuGn, BuPu, GnBu, Greens, Greys, Oranges, OrRd, PuBu, PuBuGn, PuRd, Purples, RdPu, Reds, YlGn, YlGnBu, YlOrBr, YlOrRd), and viridis.}
}
\value{
A ggplot2 object showing partial dependence according to the oblique random survival forest object.
}
\description{
Plot partial variable dependence using an oblique random survival forest
}
\examples{
\dontrun{
data("pbc",package='survival')
pbc$status[pbc$status>=1]=pbc$status[pbc$status>=1]-1
pbc$time=pbc$time/365.25
pbc$id=NULL
fctrs<-c('trt','ascites','spiders','edema','hepato','stage')
for(f in fctrs)pbc[[f]]=as.factor(pbc[[f]])
pbc=na.omit(pbc)

orsf=ORSF(data=pbc, eval_time=1:10,ntree=30)

pdplot(object=orsf, xvar='bili', xlab='Bilirubin', 
       xvar_units='mg/dl', sub_times=10)
}
}
