% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTranscriptAttributes.R
\name{getTranscriptAttributes}
\alias{getTranscriptAttributes}
\title{Gets transcript attribute values for given transcript IDs.}
\usage{
getTranscriptAttributes(labbcat.url, transcriptIds, layerIds)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}

\item{transcriptIds}{A vector of transcript IDs}

\item{layerIds}{A vector of layer IDs corresponding to transcript attributes. In
general, these are layers whose ID is prefixed 'transcript_', however formally it's
any layer where layer$parentId == 'graph' && layer$alignment == 0, which includes
'corpus' as well as transcript attribute layers.}
}
\value{
A data frame of attribute value labels.
}
\description{
Gets transcript attribute values for given transcript IDs.
}
\examples{
\dontrun{
## define the LaBB-CAT URL
labbcat.url <- "https://labbcat.canterbury.ac.nz/demo/"

## Get language, duration, and corpus for transcripts starting with 'BR'
attributes <- getTranscriptAttributes(labbcat.url,
            getMatchingTranscriptIds(labbcat.url, "id MATCHES 'BR.+'"),
            c('transcript_language', 'transcript_duration', 'corpus'))

}

}
\keyword{annotation}
\keyword{label}
\keyword{layer}
