% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nzffdr_widen_habitat.R
\name{nzffdr_widen_habitat}
\alias{nzffdr_widen_habitat}
\title{Converts habitat variables to tidy wide format}
\usage{
nzffdr_widen_habitat(
  fishd,
  cols_to_expand = c("habitatFlowPercent", "habitatInstreamCoverPresent",
    "habitatRiparianVegPercent", "habitatSubstratePercent")
)
}
\arguments{
\item{fishd}{an NZFFD dataframe returned from nzffdr_import.}

\item{cols_to_expand}{the habitat columns to expand, can be any combination
of "habitatFlowPercent", "habitatInstreamCoverPresent",
"habitatRiparianVegPercent", "habitatSubstratePercent".}
}
\value{
An NZFFD dataframe with added wide format columns for each of the 
selected habitat columns.
}
\description{
Converts habitat variables to tidy wide format columns and appends to 
original dataframe.
}
\examples{
nzffdr_widen_habitat(nzffdr::nzffdr_data)
}
