% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nyc_domestic_violence_annual_report.R
\name{nyc_domestic_violence_annual_report}
\alias{nyc_domestic_violence_annual_report}
\title{Annual Report on Domestic Violence Initiatives, Indicators and Factors}
\source{
NYC Open Data: <https://data.cityofnewyork.us/Social-Services/Annual-Report-on-Domestic-Violence-Initiatives-Ind/7t9i-jsfp/about_data>
}
\usage{
nyc_domestic_violence_annual_report(
  limit = 10000,
  filters = list(),
  timeout_sec = 30
)
}
\arguments{
\item{limit}{Number of rows to retrieve (default = 10,000).}

\item{filters}{Optional list of field-value pairs to filter results.}

\item{timeout_sec}{Request timeout in seconds (default = 30).}
}
\value{
A tibble containing Annual Report on Domestic Violence Initiatives, Indicators and Factors data.
}
\description{
Downloads Annual Report on Domestic Violence Initiatives, Indicators and Factors data from NYC Open Data.
}
\details{
The information in the report is required under Local Law 38 of 2019.
}
\examples{
# Examples that hit the live NYC Open Data API are wrapped so CRAN checks
# do not fail when the network is unavailable or slow.
\donttest{
if (curl::has_internet()) {
  # Quick example (fetch 2 rows)
  small_sample <- nyc_domestic_violence_annual_report(limit = 2)
  small_sample

  nyc_domestic_violence_annual_report(filters = list(category = "FJC_Client_Visits"))
}
}
}
