% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_percent.R
\name{f_percent}
\alias{f_percent}
\alias{ff_percent}
\alias{f_prop2percent}
\alias{ff_prop2percent}
\title{Format Percentages}
\usage{
f_percent(x, digits = getOption("numformdigits"), less_than_replace = FALSE,
  ...)

ff_percent(...)

f_prop2percent(x, digits = getOption("numformdigits"),
  less_than_replace = FALSE, ...)

ff_prop2percent(...)
}
\arguments{
\item{x}{A vector of proportions.}

\item{digits}{The number of digits to use.  Defaults to 1.  Can be set
globally via: \code{options(numformdigits = n)} where n is the number of
digits beyond the decimal point to include.}

\item{less_than_replace}{logical.  If \code{TRUE} values lower than lowest
place value, specified by \code{digits}, will be replaces with a less than
sign followed by the \code{double} representation of the place value
specified by \code{digits}.  For example, if \code{digits = 0} then
replacement will be \code{"<1\%"} or if \code{digits = 2} then replacement will
be \code{"<.01\%"}.}

\item{\ldots}{Other values passed to \code{\link[numform]{f_num}}.}
}
\value{
Returns a string of publication ready digits.
}
\description{
\code{f_percent} - A wraf_percenter for \code{\link[numform]{f_num}} that formats
percent values as labeled percentages.

\code{f_prop2percent} - A wrapper for \code{\link[numform]{f_num}} that formats
proportions as labeled percentages.
}
\examples{
f_percent(c(30, 33.45, .1))
f_percent(c(30, 33.45, .1), 1)
f_percent(c(0.0, 0, .2, -00.02, 1.122222, pi))
f_prop2percent(c(.30, 1, 1.01, .33, .222, .01))

f_percent(c(30, 33.45, .1), digits = 0, less_than_replace = TRUE)
f_prop2percent(c(.30, 1, 1.01, .33, .222, .01, .0001, NA), digits = 0,
    less_than_replace = TRUE)

\dontrun{
if (!require("pacman")) install.packages("pacman")
pacman::p_load(ggplot2, dplyr)

mtcars \%>\%
    count(cyl, gear) \%>\%
    group_by(cyl) \%>\%
    mutate(prop = n/sum(n)) \%>\%
    ggplot(aes(gear, prop)) +
        geom_bar(stat = 'identity') +
        facet_wrap(~cyl, ncol = 1) +
        scale_y_continuous(labels = ff_prop2percent(digits = 0))
}
}
\seealso{
\code{\link[numform]{f_num}}
}
