% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distances.r
\name{reg_dist}
\alias{reg_dist}
\title{Distance based on the regression parameters}
\usage{
reg_dist(X, PX, nbins = 1, intercept = TRUE, scale = TRUE)
}
\arguments{
\item{X}{a data.frame with two variables, the first column giving
the explanatory variable and the second column giving the response
variable}

\item{PX}{another data.frame with two variables, the first column giving
the explanatory variable and the second column giving the response
variable}

\item{nbins}{number of bins on the x-direction, by default nbins = 1}

\item{intercept}{include the distances between intercepts?}

\item{scale}{logical value: should the variables be scaled before computing regression coefficients?}
}
\value{
distance between X and PX
}
\description{
Dataset X is binned into 5 bins in x-direction. A regression line is fitted to the
data in each bin and the regression coefficients are noted. Same is done for
dataset PX. An euclidean distance is calculated between the two sets of regression
parameters. If the relationship between X and PX looks linear, number of bins should
be equal to 1.
}
\examples{
with(mtcars, reg_dist(data.frame(wt, mpg), data.frame(sample(wt), mpg)))
}
