% Generated by roxygen2 (4.0.2): do not edit by hand
\name{distplot}
\alias{distplot}
\title{Plotting the distribution of the distance measure}
\usage{
distplot(dat, m = 20)
}
\arguments{
\item{dat}{output from \code{\link{distmet}}}

\item{m}{the number of plots in the lineup; m = 20 by default}
}
\description{
The permutation distribution of the distance measure is plotted with the distances for
the null plots. Distance measure values for the null plots and the true plot are overlaid.
}
\examples{
if(require('dplyr')){
d <- lineup(null_permute('mpg'), mtcars, pos = 1)
qplot(mpg, wt, data=d) + facet_wrap(~.sample)
distplot(distmet(d, var = c('mpg', 'wt'), 'reg_dist', null_permute('mpg'),
pos = 1, repl = 100, m = 8), m = 8) }
}

