% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nsnorm.R
\name{Neutrosophic Normal}
\alias{Neutrosophic Normal}
\alias{dnsnorm}
\alias{pnsnorm}
\alias{qnsnorm}
\alias{rnsnorm}
\title{Neutrosophic Normal Distribution}
\usage{
dnsnorm(x, mean, sd)

pnsnorm(q, mean, sd, lower.tail = TRUE)

qnsnorm(p, mean, sd)

rnsnorm(n, mean, sd)
}
\arguments{
\item{x}{a vector or matrix of observations for which the pdf needs to be computed.}

\item{mean}{the mean, which must be an interval.}

\item{sd}{the standard deviations that must be positive.}

\item{q}{a vector or matrix of quantiles for which the cdf needs to be computed.}

\item{lower.tail}{logical; if TRUE (default), probabilities are
\eqn{P(X \ge x)}; otherwise, \eqn{P(X >x)}.}

\item{p}{a vector or matrix of probabilities for which the quantile needs to be computed.}

\item{n}{number of random values to be generated.}
}
\value{
\code{pnsnorm} gives the distribution function,
\code{dnsnorm} gives the density,
\code{qnsnorm} gives the quantile function and
\code{rnsnorm} generates random variables from the neutrosophic normal distribution.
}
\description{
Density, distribution function, quantile function and random
generation for the nuetrosophic generalized exponential
distribution with parameters \code{mean} =  \eqn{\mu_N} and standard deviation
\code{sd} = \eqn{\sigma_N}.
}
\details{
The neutrosophic normal distribution with parameters mean
\eqn{\mu_N} and standard deviation \eqn{\sigma_N} has density function
\deqn{f_N(x) = \frac{1}{\sigma_N \sqrt{2 \pi}} \exp\{\left(\frac{\left(X-\mu_N\right)^2}{2 \sigma_N^2}\right)}\}
for \eqn{\mu_N \in (\mu_L, \mu_U)}, the mean which must be an interval, and
\eqn{\sigma_N \in (\sigma_L, \sigma_U)}, the standard deviation which must
also be a positive interval, and \eqn{-\infty < x < \infty}.
}
\examples{
data(balls)
dnsnorm(x = balls, mean = c(72.14087, 72.94087), sd = c(37.44544, 37.29067))

pnsnorm(q = 5, mean = c(72.14087, 72.94087), sd = c(37.44544, 37.29067))

# Calculate quantiles
qnsnorm(p = c(0.25, 0.5, 0.75), mean = c(9.1196, 9.2453), sd = c(10.1397, 10.4577))

# Simulate 10 values
rnsnorm(n = 10, mean = c(4.141, 4.180), sd = c(0.513, 0.521))

}
\references{
Patro, S. and Smarandache, F. (2016). The Neutrosophic Statistical Distribution, More Problems, More Solutions. Infinite Study.
}
