% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dots.R
\name{get_dots}
\alias{get_dots}
\alias{set_dots}
\title{Set or get the contents of \code{...}.}
\usage{
get_dots(env = caller(environment()), inherits = FALSE)

set_dots(env, d, append = FALSE)
}
\arguments{
\item{env}{The environment to look in.}

\item{inherits}{Whether to pull '...' from enclosing environments.}

\item{d}{a \code{[dots]} object.}

\item{append}{if TRUE, the values should be appended to the
existing binding. If false, existing binding for "..." will be
replaced.}
}
\value{
\code{get_dots} returns a \link{dots} list. If \code{...} is not bound or
is missing, it returns an empty dots list.

\code{set_dots} returns the updated environment, invisibly.
}
\description{
\code{get_dots()} unpacks \code{...} from a given environment and returns a
\link{dots} object.

\code{set_dots} takes a \link{dots} list and uses it to create a binding for
\code{...} in a given environment.
}
\details{
\code{get_dots()} is equivalent to \code{dots(...)} or
\code{arg_list( (...) )}.
}
\seealso{
env2dots set_arg dots2env
}
