\name{kappasb}
\alias{kappasb}
\title{Coefficients of an extended Shapiro-Botha variogram model}
\usage{
  kappasb(x, dk = 0)
}
\arguments{
  \item{x}{numeric vector (on which the kappa function will
  be evaluated).}

  \item{dk}{dimension of the kappa function.}
}
\value{
  A vector with the coefficients of an extended
  Shapiro-Botha variogram model.
}
\description{
  Computes the coefficients of an extended Shapiro-Botha
  variogram model.
}
\details{
  If \code{dk >= 1}, the coefficients are computed as:
  \deqn{\kappa_d(x) = (2/x)^{(d-2)/2} \Gamma(d/2)
  J_{(d-2)/2}(x)} where \eqn{J_p} is the Bessel function of
  order \eqn{p}. \cr If \code{dk == 0}, the coefficients
  are computed as: \deqn{\kappa _\infty(x) = e^{-x^2}}
  (corresponding to a model valid in any spatial
  dimension). \cr NOTE: some authors denote these functions
  as \eqn{\Omega_d}.
}
\examples{
kappasb(seq(0, 6*pi, len = 10), 2)

curve(kappasb(x/5, 0), xlim = c(0, 6*pi), ylim = c(-1, 1), lty = 2)
for (i in 1:10) curve(kappasb(x, i), col = gray((i-1)/10), add = TRUE)
abline(h = 0, lty = 3)
}
\references{
  Shapiro, A. and Botha, J.D. (1991) Variogram fitting with
  a general class of conditionally non-negative definite
  functions. \emph{Computational Statistics and Data
  Analysis}, \bold{11}, 87-96.
}
\seealso{
  \code{\link{svarmod.sb.iso}}, \code{\link{besselJ}}.
}

