% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertStatusCodes.R
\name{convertStatusCodes}
\alias{convertStatusCodes}
\title{Converts status indicators to a Standardized code}
\usage{
convertStatusCodes(status)
}
\arguments{
\item{status}{character vector or NA. Flag indicating an individual's
status as alive, dead, sold, etc.}
}
\value{
A factor vector of the standardized status codes with levels:
\code{ALIVE}, \code{DECEASED}, \code{SHIPPED}, and \code{UNKNOWN}.
}
\description{
Part of Pedigree Curation
}
\examples{
library(nprcgenekeepr)
original <- c(
  "A", "alive", "Alive", "1", "S", "Sale", "sold", "shipped",
  "D", "d", "dead", "died", "deceased", "2",
  "shiped", "3", "U", "4", "unknown", NA,
  "Unknown", "H", "hermaphrodite", "U", "Unknown", "4"
)
convertStatusCodes(original)
}
