% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epps_test.R
\name{epps.statistic}
\alias{epps.statistic}
\title{Estimates the Epps statistic}
\usage{
epps.statistic(y)
}
\arguments{
\item{y}{a numeric vector or an object of the \code{ts} class containing a stationary time series.}
}
\value{
a real value with the Epps test's statistic.
}
\description{
Estimates the Epps statistic minimizing the quadratic loss of the process'
characteristic function in terms of the first two moments.
}
\details{
This function is the equivalent of \code{Sub} in \emph{Nieto-Reyes, A.,
Cuesta-Albertos, J. & Gamboa, F. (2014)}. This function uses a quadratic
optimization solver implemented by \emph{Press, W.H., Teukolsky, S.A.,
Vetterling, W.T. and  Flannery, B.P. (2007)}.
}
\examples{
# Generating an stationary arma process
y = arima.sim(100,model = list(ar = 0.3))
epps.statistic(y)

}
\references{
Epps, T.W. (1987). Testing that a stationary time series is Gaussian. \emph{The
Annals of Statistic}. 15(4), 1683-1698.

Nieto-Reyes, A., Cuesta-Albertos, J. & Gamboa, F. (2014). A random-projection
based test of Gaussianity for stationary processes. \emph{Computational
Statistics & Data Analysis, Elsevier}, vol. 75(C), pages 124-141.

Press, W.H., Teukolsky, S.A., Vetterling, W.T. and  Flannery, B.P. (2007).
Numerical Recipes. The Art of Scientific Computing. \emph{Cambridge
University Press}.
}
\seealso{
\code{\link{lobato.statistic}}
}
\author{
Alicia Nieto-Reyes and Asael Alonzo Matamoros.
}
