% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dat_col_names_prime.R
\name{dat_col_names_prime}
\alias{dat_col_names_prime}
\title{Title: Attribute(s) naming function.}
\usage{
dat_col_names_prime(
  df,
  rows_used = NULL,
  cols_used = NULL,
  user_specific_labels = NULL
)
}
\arguments{
\item{df}{A data frame that requires attribute labels.}

\item{rows_used}{A character vector indicating the rows or tuples used on the microplate (usually a 96-well microplate). Initialized as NULL.}

\item{cols_used}{A numeric vector indicating the plate columns or attributes used. Initialized as NULL.}

\item{user_specific_labels}{A character vector where the user manually enters the used microplate wells based on the FLUOstar plate layout.}
}
\value{
Returns a character vector of attribute(s) names for the normalized data frame.
}
\description{
This function is used to name attribute(s).
Attribute(s) names, in this case, are equivalent to the well labels found on the microplate reader.
An attribute for a sample loaded into row A - column 1 will be named A1.
In short, the function takes a clean data frame and returns attribute names
that match the FLUOstar plate layout often presented as an Excel file.
}
\examples{
fpath <- system.file("extdata", "dat_1.dat", package = "normfluodbf", mustWork = TRUE)
dat_df <- read.table(file=fpath)
nocomma_dat <- clean_odd_cc(dat_df)
resampled_scaled <- resample_dat_scale(nocomma_dat, tnp=3, cycles=40)
n = c('A','B','C')
sample_col_names <- dat_col_names_prime(resampled_scaled, n)
}
\seealso{
\code{\link[=normfluordat]{normfluordat()}}
}
\author{
Tingwei Adeck
}
