% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_GOFs.R
\name{histGOF}
\alias{histGOF}
\title{Histogram GOF}
\usage{
histGOF(data, x, title = "", color = "", fx = NULL, bins = NA,
  refline = TRUE, control = GOF.control())
}
\arguments{
\item{data}{data.frame to plot}

\item{x}{character string with name of column for x}

\item{title}{title}

\item{color}{data columns to set different colors in plot, interpreted as factor}

\item{fx}{function for transformation of x before plotting}

\item{bins}{number of histogram bins, if NA, bins are set using Sturges' formula}

\item{refline}{add reference line (default =TRUE) or not (FALSE)}

\item{control}{an optional list of control settings. See GOF.control for the names of the settable control values and their effect.}
}
\description{
Histogram GOF showing histogram, smooth density, and normal density as reference line
and caption added as reurned by get.caption
}
\examples{
dd<-data.frame(CWRES=rnorm(100),gr=rep(LETTERS[1:5],20))
histGOF(dd,"CWRES",color="gr")

}
