% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/burnaby.R
\name{burnaby}
\alias{burnaby}
\title{Burnaby (BU) Measure}
\usage{
burnaby(data, var.weights = NULL)
}
\arguments{
\item{data}{A data.frame or a matrix with cases in rows and variables in columns.}

\item{var.weights}{A numeric vector setting weights to the used variables. One can choose the real numbers from zero to one.}
}
\value{
The function returns an object of the class "dist".
\cr
}
\description{
The function calculates a dissimilarity matrix based on the BU similarity measure.
}
\details{
The Burnaby similarity measure was presented in (Burnaby, 1970).
The measure assigns low similarity to mismatches on rare values and high similarity to mismatches on frequent values, see (Borian et al., 2008).
}
\examples{
# sample data
data(data20)

# dissimilarity matrix calculation
prox.burnaby <- burnaby(data20)

# dissimilarity matrix calculation with variable weights
weights.burnaby <- burnaby(data20, var.weights = c(0.7, 1, 0.9, 0.5, 0))

}
\references{
Burnaby T. (1970). On a method for character weighting a similarity coefficient, employing the concept of information.
Mathematical Geology, 2(1), 25-38.
 \cr
 \cr
Boriah S., Chandola V., Kumar V. (2008). Similarity measures for categorical data: A comparative evaluation.
In: Proceedings of the 8th SIAM International Conference on Data Mining, SIAM, p. 243-254.
}
\seealso{
\code{\link[nomclust]{anderberg}},
\code{\link[nomclust]{eskin}},
\code{\link[nomclust]{gambaryan}},
\code{\link[nomclust]{goodall1}},
\code{\link[nomclust]{goodall2}},
\code{\link[nomclust]{goodall3}},
\code{\link[nomclust]{goodall4}},
\code{\link[nomclust]{iof}},
\code{\link[nomclust]{lin}},
\code{\link[nomclust]{lin1}},
\code{\link[nomclust]{of}},
\code{\link[nomclust]{sm}},
\code{\link[nomclust]{smirnov}},
\code{\link[nomclust]{ve}},
\code{\link[nomclust]{vm}}.
}
\author{
Zdenek Sulc. \cr Contact: \email{zdenek.sulc@vse.cz}
}
