% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.r
\name{funsXsq.nnsym.ss}
\alias{funsXsq.nnsym.ss}
\alias{Xsq.nnsym.ss.ct}
\alias{Xsq.nnsym.ss}
\title{Pielou's First Type of NN Symmetry Test with Chi-square Approximation for multiple classes
(for Sparse Sampling)}
\usage{
Xsq.nnsym.ss.ct(ct, cont.corr = TRUE)

Xsq.nnsym.ss(dat, lab, cont.corr = TRUE, ...)
}
\arguments{
\item{ct}{A nearest neighbor contingency table, used in \code{Xsq.nnsym.ss.ct} only}

\item{cont.corr}{A logical argument (default=\code{TRUE}). 
If \code{TRUE} the continuity correction to McNemar's test is implemented, 
and if \code{FALSE} such a correction is not implemented.}

\item{dat}{The data set in one or higher dimensions, each row corresponds to a data point,
used in \code{Xsq.nnsym.ss} only}

\item{lab}{The \code{vector} of class labels (numerical or categorical), used in \code{Xsq.nnsym.ss} only}

\item{\dots}{are for further arguments, such as \code{method} and \code{p}, passed to the \code{\link[stats]{dist}} function.
used in \code{Xsq.nnsym.ss} only}
}
\value{
A \code{list} with the elements
\item{statistic}{The chi-squared test statistic for Pielou's first type of NN symmetry test}
\item{stat.names}{Name of the test statistic}
\item{p.value}{The \eqn{p}-value for the hypothesis test}
\item{df}{Degrees of freedom for the chi-squared test, which is \eqn{k(k-1)/2} for this function.}
\item{estimate}{Estimates, i.e., absolute differences of the off-diagonal entries of 
NNCT (in the upper-triangular form).}
\item{est.name,est.name2}{Names of the estimates, former is a shorter description of the estimates
than the latter.}
\item{null.value}{Hypothesized null values for the differences between the expected values of the off-diagonal 
entries, which is 0 for this function.}
\item{method}{Description of the hypothesis test}
\item{ct.name}{Name of the contingency table, \code{ct}, returned by \code{Xsq.nnsym.ss.ct} only}
\item{data.name}{Name of the data set, \code{dat}, returned by \code{Xsq.nnsym.ss} only}
}
\description{
Two functions: \code{Xsq.nnsym.ss.ct} and \code{Xsq.nnsym.ss}.

Both functions are objects of class \code{"Chisqtest"} but with different arguments (see the parameter list below).
Each one performs the hypothesis test of equality of the expected value of the off-diagonal 
cell counts (i.e., entries) under RL or CSR in the NNCT for \eqn{k \ge 2} classes.
That is, each performs Pielou's first type of NN symmetry test which is also equivalent to McNemar's
test on the NNCT. The test is appropriate (i.e. have the appropriate asymptotic sampling distribution)
provided that data is obtained by sparse sampling.
(See \insertCite{ceyhan:SWJ-spat-sym2014;textual}{nnspat} for more detail).

Each symmetry test is based on the chi-squared approximation of the corresponding quadratic form
and are due to \insertCite{pielou:1961;textual}{nnspat}.

The argument cont.corr is a logical argument (default=\code{TRUE}) for continuity correction to this test.
If \code{TRUE} the continuity correction to McNemar's test is implemented, 
and if \code{FALSE} such a correction is not implemented. 

Each function yields the test statistic, \eqn{p}-value and \code{df} which is \eqn{k(k-1)/2}, description of the 
alternative with the corresponding null values (i.e. expected values) of differences of the off-diagonal entries,(which is
0 for this function) and also the sample estimates (i.e. observed values) of absolute differences of th
off-diagonal entries of NNCT (in the upper-triangular form).
The functions also provide names of the test statistics, the method and the data set used.

The null hypothesis is that \eqn{E(N_{ij})=E(N_{ji})} for all entries for \eqn{i \ne j} (i.e., symmetry in the 
mixed NN structure).
In the output, the test statistic, \eqn{p}-value and \code{df} are valid only for (properly) sparsely sampled data.

See also
(\insertCite{pielou:1961,ceyhan:SWJ-spat-sym2014;textual}{nnspat})
and the references therein.
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)
ct

Xsq.nnsym.ss(Y,cls)
Xsq.nnsym.ss.ct(ct)

Xsq.nnsym.ss(Y,cls,method="max")

Xsq.nnsym.ss(Y,cls,cont.corr=FALSE)
Xsq.nnsym.ss.ct(ct,cont.corr=FALSE)

#cls as a factor
na<-floor(n/2); nb<-n-na
fcls<-rep(c("a","b"),c(na,nb))
Xsq.nnsym.ss(Y,fcls)

#############
n<-40
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:4,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

Xsq.nnsym.ss(Y,cls)
Xsq.nnsym.ss.ct(ct)
Xsq.nnsym.ss.ct(ct,cont.corr = FALSE)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{Znnsym2cl.ss.ct}}, \code{\link{Znnsym2cl.ss}}, \code{\link{Znnsym.ss.ct}},
\code{\link{Znnsym.ss}}, \code{\link{Xsq.nnsym.dx.ct}}, \code{\link{Xsq.nnsym.dx}}
and \code{\link{Qsym.test}}
}
\author{
Elvan Ceyhan
}
