% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nneo_data.R
\name{nneo_data}
\alias{nneo_data}
\alias{nneo_file}
\title{Data}
\usage{
nneo_data(product_code, site_code, year_month, package = NULL, ...)

nneo_file(product_code, site_code, year_month, filename, ...)
}
\arguments{
\item{product_code}{(character) a product code. required.}

\item{site_code}{(character) a site code. required.}

\item{year_month}{(character) YYYY-MM month to check for files. required.}

\item{package}{(character) Package type to return, basic or expanded.
optional.}

\item{...}{named curl options passed on to \code{\link[crul]{HttpClient}},
e.g., \code{list(verbose = TRUE)} or \code{list(timeout_ms = 1000)}}

\item{filename}{(character) a file name. optional.}
}
\value{
\code{nneo_data} returns a list, while \code{nneo_file} returns
a tibble/data.frame
}
\description{
Data
}
\details{
\code{nneo_data} gets files available for a given
product/site/month combination.

\code{nneo_file} gets a file, and returns a data.frame
}
\examples{
\dontrun{
nneo_data(product_code = "DP1.00098.001", site_code = "HEAL",
  year_month = "2016-05")

nneo_data(product_code = "DP1.00098.001", site_code = "HEAL",
  year_month = "2016-05")

## with a package
nneo_data(product_code = "DP1.00098.001", site_code = "HEAL",
  year_month = "2016-05", package = "basic")
nneo_data(product_code = "DP1.00098.001", site_code = "HEAL",
  year_month = "2016-05", package = "expanded")

## with a file name
fname <- "NEON.D19.HEAL.DP1.00098.001.00000.000.040.001.RH_1min.csv"
nneo_file(product_code = "DP1.00098.001", site_code = "HEAL",
  year_month = "2016-05", filename = fname)

## curl options
nneo_data(product_code = "DP1.00098.001", site_code = "HEAL",
  year_month = "2016-05", verbose = TRUE)
}
}
