% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cacheit.R
\name{cacheit}
\alias{cacheit}
\title{Function to cache long operations}
\usage{
cacheit(name, code, dir, createdir = FALSE, clearcache = FALSE)
}
\arguments{
\item{name}{Name of the file to create without extension}

\item{code}{Expression of the code to execute and cache}

\item{dir}{Name of cache directory which should be placed in the working directory}

\item{createdir}{Logical about whether to create the directory if it does not
exist}

\item{clearcache}{Logical about whether to recalculate the cached .rds file
for this object}
}
\value{
Output of code, either freshly executed if the file does not exist or
  or clearcache is TRUE otherwise returns result from the cache file
}
\description{
Save results from code that takes a long time to execute to a .rds file
if that file does not exist in the cache directory. If the file exists in the
cache directory, that file will be loaded to memory without evaluating the code.
}
\details{
For more information, please refer to the vignette using
\code{browseVignettes("nncc")}.
}
