% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmfem_mult_modelselection.R
\name{nmfem_mult_modelselection}
\alias{nmfem_mult_modelselection}
\title{Model selection in NMF-EM algorithm for mixture of multinomials}
\usage{
nmfem_mult_modelselection(X, maxK = 30, save = FALSE, path = ".")
}
\arguments{
\item{X}{numeric matrix containing multinomials observations of dimension \code{N} (number of observation) \code{x M} (number of variables).}

\item{maxK}{integer. Maximum number of clusters to be tested. By default, function tests from 2 to 30 clusters.}

\item{save}{logical. Whether the result of each parameter couple \code{(H,K)} tested got to be saved.}

\item{path}{path to save the results if \code{save = TRUE}. By default, it is the working directory. Three directories are created to save the results. Directory "Initializations" contains the initialization of the algorithm for each value of K. Matrices are saved in directory "Matrices", and plots in directory "Results".}
}
\description{
The function proceed to a model selection with NMF-EM algorithm on mixture of multinomials dataset.
First, the function plots the log-likelihood in function of K.
Second, log-likelihood is plotted in function of H.
We recommend the user to choose K and H by slope heuristic method.
}
\examples{

# Example on the complete data - needs around an hour to run
\dontrun{
nmfem_mult_modelselection(travelers[ ,-1])
}
}
