"denoiseperm" <-
function(x,f,pred=LinearPred,neigh=1,int=TRUE,clo=FALSE,keep=2,rule="median",per 
= sample(1:length(x), (length(x) -
        keep), FALSE) ){

#denoises input using prediction scheme specified by other arguments
#artificial level thresholding, values generated by ebayesthresh using normalized detail coefficients

newcoeff<-NULL
ndetlist<-list()
tclist<-list()

temp<-transmatdualperm(x,f,pred,neigh,int,clo,keep,perm=per)
w<-temp$Wnew
out<-temp$out

#work out sd for normalising...

indsd<-sqrt(diag(w%*%t(w)))    #this will contain the sd of the scaling coefficients as well
norcoeff<-out$coeff/indsd

nonorcoeff<-out$coeff

lr<-out$lengthsremove    #vector deciding how to divide up coefficients into artificial levels
rem<-out$removelist      #used to convert output to original lr,rem)

al<-artlev(lr,rem)      #the list of indices of removelist separated into levels

levno<-length(al)
for (i in 1:levno){
ndetlist[[i]]<-norcoeff[al[[i]]]
	}

sd<-mad(ndetlist[[1]])    #uses the first (largest) level to estimate noise standard deviation
sd1<-mad(ndetlist[[1]],center=0)
sd2<-mad(norcoeff[rem]) #uses all the normalised details to estimate the noise std dev

for (i in 1:levno){
tclist[[i]]<-ebayesthresh(ndetlist[[i]],prior="cauchy",a=NA,sdev=sd,threshrule=rule)
	}

#^^^creates list of thresholded coefficients (in levels) using HARD threshold scheme and post. median values 

for (i in 1:levno){
newcoeff[al[[i]]]<-tclist[[i]]*indsd[al[[i]]]
}

newcoeff[out$pointsin]<-out$coeff[out$pointsin]

#^^^^^^^^^new unnormalised coeff vector (details and scaling coeffs)


fhat<-invtnp(x,newcoeff,out$lengths,lr,out$pointsin,rem,out$neighbrs,out$schemehist,out$interhist,length(x)-keep,int,neigh,clo,pred)

return(list(out=out,w=w,indsd=indsd,al=al,sd=sd,fhat=fhat))
}









