% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simdesign_helper.R
\name{simdesign_ABCmcmc_Marjoram_original}
\alias{simdesign_ABCmcmc_Marjoram_original}
\title{Add an Approximate Bayesian Computation (Monte-Carlo Markov-Chain) simdesign using the Majoram Original algorithm to a nl object}
\usage{
simdesign_ABCmcmc_Marjoram_original(
  nl,
  postpro_function = NULL,
  summary_stat_target,
  prior_test = NULL,
  n_rec,
  n_between_sampling = 10,
  n_cluster = 1,
  use_seed = FALSE,
  dist_weights = NULL,
  dist_max = 0,
  tab_normalization = summary_stat_target,
  proposal_range = vector(mode = "numeric", length = length(getexp(nl, "variables"))),
  seed_count = 0,
  progress_bar = FALSE,
  nseeds
)
}
\arguments{
\item{nl}{nl object with a defined experiment}

\item{postpro_function}{default is NULL. Allows to provide a function that is called to post-process the output Tibble of the NetLogo simulations. The function must accept the nl object with attached results as input argument. The function must return a one-dimensional vector of output metrics that corresponds in leght and order to the specified summary_stat_target.}

\item{summary_stat_target}{a vector of target values in the same order as the defined metrics of the experiment}

\item{prior_test}{a string expressing the constraints between model parameters. This expression will be evaluated as a logical expression, you can use all the logical operators including "<", ">", ... Each parameter should be designated with "X1", "X2", ... in the same order as in the prior definition. Set to NULL to disable.}

\item{n_rec}{Number of samples along the MCMC}

\item{n_between_sampling}{a positive integer equal to the desired spacing between sampled points along the MCMC.}

\item{n_cluster}{number of cores to parallelize simulations. Due to the design of the EasyABC parallelization it is currently not possible to use this feature with cores > 1.}

\item{use_seed}{if TRUE, seeds will be automatically created for each new model run}

\item{dist_weights}{a vector containing the weights to apply to the distance between the computed and the targeted statistics. These weights can be used to give more importance to a summary statistic for example. The weights will be normalized before applying them. Set to NULL to disable.}

\item{dist_max}{a positive number. This is the tolerance threshold used during the MCMC. If not provided by the user, it is automatically computed as half the distance between the first simulation and the target summary statistics and a warning is printed.}

\item{tab_normalization}{a vector of the same length as summary_stat_target. Each element contains a positive number by which each summary statistics must be divided before the computation of the Euclidean distance between simulations and data. If not provided by the user, the simulated summary statistics are divided by the target summary statistics and a warning is printed.}

\item{proposal_range}{a vector of the same length as the number of model parameters, used when method is "Marjoram_original". Each element contains a positive number defining the range of MCMC jumps for each model parameter. If not provided by the user, a default value is used for each parameter and a warning is printed. The default value is 1/50 of the prior range for uniform distributions, 1/20 of the standard deviation of the prior distribution for normal distributions, 1/20 * exp ( sigma * sigma}

\item{seed_count}{a positive integer, the initial seed value provided to the function model (if use_seed=TRUE). This value is incremented by 1 at each call of the function model.}

\item{progress_bar}{logical, FALSE by default. If TRUE, ABC_mcmc will output a bar of progression with the estimated remaining computing time. Option not available with multiple cores.}

\item{nseeds}{number of seeds for this simulation design}
}
\value{
simdesign S4 class object
}
\description{
Add an Approximate Bayesian Computation (Monte-Carlo Markov-Chain) simdesign using the Majoram Original algorithm to a nl object
}
\details{
This function creates a simdesign S4 class which can be added to a nl object.

Variables in the experiment variable list need to provide a numeric distribution with min, max and a shape of the distribution (qunif, qnorm, qlnorm, qexp)(e.g. list(min=1, max=4, qfun="qunif")).

The function uses the EasyABC package to set up the ABC_mcmc function.
For details on the ABC_mcmc function parameters see ?EasyABC::ABC_mcmc
Finally, the function reports a simdesign object.

Approximate Bayesian Computation simdesigns can only be executed using the \link[nlrx]{run_nl_dyn} function instead of \link[nlrx]{run_nl_all} or \link[nlrx]{run_nl_one}.
}
\examples{

# To attach a simdesign, a nl object needs to be created first (see ?nl).
# For this example, we load a nl object from test data.

nl <- nl_lhs

# Attach the simdesign to the nl object
nl@simdesign <- simdesign_ABCmcmc_Marjoram_original(nl = nl,
                                                     summary_stat_target = c(100, 80),
                                                     n_rec = 100,
                                                     n_between_sampling = 10,
                                                     nseeds = 1)

}
