% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postHPDplot.R
\name{postHPDplot}
\alias{postHPDplot}
\title{Plot Marginal Posterior Distribution}
\usage{
postHPDplot(
  x,
  prob = 0.9,
  bw = "SJ",
  hpd.col = "lightblue",
  line.col = "darkgrey",
  rnd = 3,
  HPD = TRUE,
  show.hpd.val = TRUE,
  ...
)
}
\arguments{
\item{x}{Posterior samples}

\item{prob}{Highest posterior density interval. Default is 0.9.}

\item{bw}{The smoothing bandwidth to be used. See \code{\link{density}} for details. Default is "SJ".}

\item{hpd.col}{Fill colour for the highest density interval. Default is 'lightblue'. Ignored when \code{HPD} is set to FALSE.}

\item{line.col}{Line color for the density plot. Default is 'darkgrey'.}

\item{rnd}{Integer indicating the number of decimal places to be used in the reporting of the highest posterior density interval.}

\item{HPD}{Whether the highest posterior density interval is highlighted or not. Default is TRUE.}

\item{show.hpd.val}{Whether the highest posterior density interval is displayed as subtitle. Default is TRUE.}

\item{...}{other graphical parameters.}
}
\value{
None.
}
\description{
Plot marginal posterior distribution highlighting user-defined higher posterior density interval.
}
