% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nimbleProject.R
\name{clearCompiled}
\alias{clearCompiled}
\title{Clear compiled objects from a project and unload shared library}
\usage{
clearCompiled(obj)
}
\arguments{
\item{obj}{A compiled nimbleFunction or nimble model}
}
\description{
Clear all compiled objects from a project and unload the shared library produced by the C++ compiler. Has no effect on Windows.
}
\details{
This will clear all compiled objects associated with your NIMBLE project.  For example, if \code{cModel} is a compiled model, \code{clearCompiled(cModel)} will clear both the model and all associated nimbleFunctions such as compiled MCMCs that use that model.

Use of this function can be dangerous.  There is some risk that if you have copies of the R objects that interfaced to compiled C++ objects that have been removed, and you attempt to use those R objects after clearing their compiled counterparts, you will crash R.  We have tried to minimize that risk, but we can't guarantee safe behavior.
}
