% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in RtmpAaCNOd/file312c33fb9092
\name{nimEigen}
\alias{eigen}
\alias{nimEigen}
\title{Spectral Decomposition of a Matrix}
\usage{
nimEigen(x, only.values = FALSE)
}
\arguments{
\item{x}{a symmetric numeric matrix (double or integer) whose spectral decomposition is to be computed.}

\item{only.values}{if TRUE, only the eigenvalues are computed, otherwise both eigenvalues and eigenvectors are computed; default is \code{FALSE}.}
}
\value{
The spectral decomposition of \code{x} is returned as a \code{\link{nimbleList}} with elements:
\itemize{
\item values vector containing the eigenvalues of \code{x}, sorted in decreasing order.  Since \code{x} is required to be symmetric, all eigenvalues will be real numbers.
\item vectors. matrix with columns containing the eigenvectors of \code{x}, or an empty matrix if \code{only.values} is \code{TRUE}.
}
}
\description{
Computes eigenvalues and eigenvectors of a numeric matrix.
}
\details{
Computes the spectral decomposition of a symmetric numeric matrix using the Eigen C++ template library.
Unlike the \code{eigen} function in base R, \code{nimEigen} only works for symmetric matrices.  In a nimbleFunction, \code{eigen} is identical to \code{nimEigen}.

Additionally, \code{returnType(eigenNimbleList())} can be used within a \code{link{nimbleFunction}} to specify that the function will return a \code{\link{nimbleList}} generated by the \code{nimEigen} function.  \code{eigenNimbleList()} can also be used to define a nested \code{\link{nimbleList}} element.  See the User Manual for usage examples.
}
\examples{
eigenvaluesDemoFunction <- nimbleFunction(
   setup = function(){
     demoMatrix <- diag(4) + 2
   },
   run = function(){
     eigenvalues <- eigen(demoMatrix)$values
     returnType(double(1))
     return(eigenvalues)
 })
}
\author{
NIMBLE development team
}
\seealso{
\code{\link{nimSvd}} for singular value decompositions in NIMBLE.
}

