% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in RtmpK6dyXN/file1e0966954b0b
\name{simNodes}
\alias{calcNodes}
\alias{getLogProbNodes}
\alias{simNodes}
\title{Basic nimbleFunctions for calculate, simulate, and getLogProb with a set of nodes}
\usage{
simNodes(model, nodes)

calcNodes(model, nodes)

getLogProbNodes(model, nodes)
}
\arguments{
\item{model}{A NIMBLE model}

\item{nodes}{A set of nodes. If none are provided, default is all \code{model$getNodeNames()}}
}
\description{
simulate, calculate, or get existing log probabilities for the current values in a NIMBLE model
}
\details{
These are basic nimbleFunctions that take a model and set of nodes and return a function that will call \code{calculate}, \code{simulate}, or \code{getLogProb} on those nodes.  Each is equivalent to a direct call from R, but in nimbleFunction form they can be be compiled and can be put into a nimbleFunctionList.  For example, \code{myCalc <- calcNodes(model, nodes); ans <- myCalc()} is equivalent to \code{ans <- calculate(model, nodes)}, but one can also do \code{CmyCalc <- compileNimble(myCalc)} to get a faster version.

In nimbleFunctions, for only one set of nodes, it is equivalent or slightly better to simply use \code{calculate(model, nodes)} in the run-time code.  The compiler will process the model-nodes combination in the same way as would occur by creating a specialized \code{calcNodes} in the setup code.  However, if there are multiple sets of nodes, one can do the following:

Setup code: \code{myCalcs <- nimbleFunctionList(calcNodes); myCalcs[[1]] <- calcNodes(model, nodes[[1]]); myCalcs[[2]] <- calcNodes[[2]]}

Run code: \code{for(i in seq_along(myCalcs)) {ans[i] <- myCalcs[[i]]()} }
}
\author{
Perry de Valpine
}

