% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tasscap_oli.R
\name{tasscap_oli}
\alias{tasscap_oli}
\title{Tasselled Cap Transformation}
\usage{
tasscap_oli(x)
}
\arguments{
\item{x}{A raster stack containing the reflectance values of the first seven Landsat OLI bands.}
}
\value{
Layer 1 - Brightness.

Layer 2 - Greenness.

Layer 3 - Wetness.
}
\description{
This function Convert Reclectance values to Brightness, Greenness and Wetness.
}
\examples{
library(raster)
path_files <- system.file("extdata/", package="nightmares")
x <- stack(list.files(path_files,".tif", full.names=TRUE))
tasscap_oli(x)

}
\references{
Baig et al., 2014. Derivation of a tasselled cap transformation based on Landsat 8 at-satellite reflectance. Remote Sensing Letters 5(5), 423-431.
}
