% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vdraw.R
\name{vdraw}
\alias{vdraw}
\title{Vectorized generic function for simulating from NHPPPs given the intensity function
or the cumulative intensity function}
\usage{
vdraw(
  lambda = NULL,
  lambda_args = NULL,
  Lambda_maj_matrix = NULL,
  lambda_maj_matrix = NULL,
  range_t = NULL,
  tol = 10^-6,
  atmost1 = FALSE,
  atleast1 = FALSE,
  use_cpp = FALSE
)
}
\arguments{
\item{lambda}{(function) a vectorized intensity function, with one or two arguments.
The first is time. The optional second (should be named \code{lambda_args}) is a named list with additional arguments.}

\item{lambda_args}{(list) optional list of named arguments for \code{lambda()}}

\item{Lambda_maj_matrix}{(matrix) for the majorizeintegrated intensity rates at the end of each interval}

\item{lambda_maj_matrix}{(matrix) intensity rates, one per interval}

\item{range_t}{(vector, or matrix) \code{t_min} and \code{t_max}, possibly vectorized}

\item{tol}{(scalar, double) tolerance for the number of events}

\item{atmost1}{boolean, draw at most 1 event time}

\item{atleast1}{boolean, draw at least 1 event time in interval}

\item{use_cpp}{boolean, use C++ code}
}
\value{
a vector of event times
}
\description{
This is a wrapper to the package's specific functions, and thus slightly slower.
For time-intensive simulations prefer one of the specific functions.
}
\examples{
Z <- vdraw(
  lambda = function(x, lambda_args = NULL) 0.1 * x,
  range_t = c(1, 10),
  lambda_maj_matrix = matrix(rep(1, 5), nrow = 1),
  atmost1 = FALSE, atleast1 = FALSE, use_cpp = TRUE
)
}
