% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_vaa.R
\name{get_vaa}
\alias{get_vaa}
\title{NHDPlusV2 Attribute Subset}
\usage{
get_vaa(
  atts = NULL,
  path = get_vaa_path(),
  download = TRUE,
  updated_network = FALSE
)
}
\arguments{
\item{atts}{character The variable names you would like, always includes comid}

\item{path}{character path where the file should be saved. Default is a
persistent system data as retrieved by \link{nhdplusTools_data_dir}.
Also see: \link{get_vaa_path}}

\item{download}{logical if TRUE, the default, will download VAA table if not
found at path.}

\item{updated_network}{logical default FALSE. If TRUE, updated network attributes
from E2NHD and National Water Model retrieved from
\doi{10.5066/P976XCVT}.}
}
\value{
data.frame containing requested VAA data
}
\description{
Return requested NHDPlusv2 Attributes.
}
\details{
The VAA data is a aggregate table of information from the NHDPlusV2
elevslope.dbf(s), PlusFlowlineVAA.dbf(s); and NHDFlowlines. All data
originates from the EPA NHDPlus Homepage
\href{https://www.epa.gov/waterdata/get-nhdplus-national-hydrography-dataset-plus-data}{here}.
To see the location of cached data on your machine use
\code{\link{get_vaa_path}}.
To view aggregate data and documentation, see
\href{https://www.hydroshare.org/resource/6092c8a62fac45be97a09bfd0b0bf726/}{here}
}
\examples{
\dontrun{
# This will download the vaa file to the path from get_vaa_path()

get_vaa("slope")
get_vaa(c("slope", "lengthkm"))

get_vaa(updated_network = TRUE)
get_vaa("reachcode", updated_network = TRUE)

#cleanup if desired
unlink(dirname(get_vaa_path()), recursive = TRUE)
}
}
