% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_network.R
\name{calculate_total_drainage_area}
\alias{calculate_total_drainage_area}
\title{Total Drainage Area}
\usage{
calculate_total_drainage_area(x)
}
\arguments{
\item{x}{data.frame with ID, toID, and area columns.}
}
\value{
numeric with total area.
}
\description{
Calculates total drainage area given a dendritic
network and incremental areas.
}
\examples{
library(dplyr)
source(system.file("extdata", "walker_data.R", package = "nhdplusTools"))
catchment_area <- prepare_nhdplus(walker_flowline, 0, 0,
                             purge_non_dendritic = FALSE, warn = FALSE) \%>\%
  left_join(select(walker_flowline, COMID, AreaSqKM), by = "COMID") \%>\%
  select(ID = COMID, toID = toCOMID, area = AreaSqKM)

new_da <- calculate_total_drainage_area(catchment_area)

catchment_area$totda <- new_da
catchment_area$nhdptotda <- walker_flowline$TotDASqKM

mean(abs(catchment_area$totda - catchment_area$nhdptotda))
max(abs(catchment_area$totda - catchment_area$nhdptotda))

}
