% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{fusions_filter}
\alias{fusions_filter}
\title{Fusions hander_data filter that can be used to prepare the input data for downstream analysis}
\usage{
fusions_filter(input_data, input_type = "common",
  config_file = system.file("extdata", "config/filter.toml", package =
  "ngstk"), config_list = NULL, hander_confg_file = system.file("extdata",
  "config/hander.toml", package = "ngstk"),
  mhander_confg_file = system.file("extdata", "config/mhander.toml", package =
  "ngstk"), hander_funs = NULL, mhander_funs = NULL,
  hander_extra_params = NULL, mhander_extra_params = NULL, outfn = NULL)
}
\arguments{
\item{input_data}{A data frame containing the fusions cols (gene5, gene3, fusion_type)}

\item{input_type}{Fusion filter type}

\item{config_file}{ngstk filter configuration file path, default is 
system.file('extdata', 'config/filter.toml', package = 'ngstk')}

\item{config_list}{ngstk filter configuration, default is NULL and 
read from config_file}

\item{hander_confg_file}{ngstk hander configuration file path, default is 
system.file('extdata', 'config/hander.toml', package = 'ngstk')}

\item{mhander_confg_file}{ngstk hander configuration file path, default is 
system.file('extdata', 'config/mhander.toml', package = 'ngstk')}

\item{hander_funs}{hander function for single colnum, 
default is NULL and get value from config_file}

\item{mhander_funs}{hander function for mulitple colnums,
#' default is NULL and get value from config_file}

\item{hander_extra_params}{Extra parameters pass to handler}

\item{mhander_extra_params}{Extra parameters pass to mhandler
system.file('extdata', 'config/filter.toml', package = 'ngstk')}

\item{outfn}{Default is NULL and not output the result to file}
}
\value{
A data frame
}
\description{
Fusions hander_data filter that can be used to prepare the input data for downstream analysis
}
\examples{
demo_file <- system.file('extdata', 
'demo/proteinpaint/fusions2pp_fusioncatcher.txt', package = 'ngstk')
input_data <- read.table(demo_file, sep = '\\t', header = TRUE, stringsAsFactors = FALSE)
result <- fusions_filter(input_data)
}
