% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate_game_stats_kicking.R
\name{calculate_player_stats_kicking}
\alias{calculate_player_stats_kicking}
\title{Summarize Kicking Stats}
\usage{
calculate_player_stats_kicking(pbp, weekly = FALSE)
}
\arguments{
\item{pbp}{A Data frame of NFL play-by-play data typically loaded with
\code{\link[=load_pbp]{load_pbp()}} or \code{\link[=build_nflfastR_pbp]{build_nflfastR_pbp()}}.}

\item{weekly}{If \code{TRUE}, returns week-by-week stats, otherwise, stats for
the entire data frame in argument \code{pbp}.}
}
\value{
a dataframe of kicking stats
}
\description{
Build columns that aggregate kicking stats at the game level.
}
\examples{
\donttest{
try({# to avoid CRAN test problems
    pbp <- nflreadr::load_pbp(2021)
    weekly <- calculate_player_stats_kicking(pbp, weekly = TRUE)
    dplyr::glimpse(weekly)

    overall <- calculate_player_stats_kicking(pbp, weekly = FALSE)
    dplyr::glimpse(overall)
})
}

}
\seealso{
\url{https://nflreadr.nflverse.com/reference/load_player_stats.html} for the nflreadr function to download this from repo (\code{stat_type = "kicking"})
}
