% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_additional_functions.R
\name{clean_pbp}
\alias{clean_pbp}
\title{Clean Play by Play Data}
\usage{
clean_pbp(pbp)
}
\arguments{
\item{pbp}{is a Data frame of play-by-play data scraped using \code{\link{fast_scraper}}.}
}
\value{
The input Data Frame of the paramter 'pbp' with the following columns
added:
\describe{
\item{success}{Binary indicator wheter epa > 0 in the given play. }
\item{passer}{Name of the dropback player (scrambles included) including plays with penalties.}
\item{passer_jersey_number}{Jersey number of the passer.}
\item{rusher}{Name of the rusher (no scrambles) including plays with penalties.}
\item{rusher_jersey_number}{Jersey number of the rusher.}
\item{receiver}{Name of the receiver including plays with penalties.}
\item{receiver_jersey_number}{Jersey number of the receiver.}
\item{pass}{Binary indicator if the play was a pass play (sacks and scrambles included).}
\item{rush}{Binary indicator if the play was a rushing play.}
\item{special}{Binary indicator if the play was a special teams play.}
\item{first_down}{Binary indicator if the play ended in a first down.}
\item{aborted_play}{Binary indicator if the play description indicates "Aborted".}
\item{play}{Binary indicator: 1 if the play was a 'normal' play (including penalties), 0 otherwise.}
\item{passer_id}{ID of the player in the 'passer' column (NOTE: ids vary pre and post 2011 but are consistent for each player. Please see details for further information)}
\item{rusher_id}{ID of the player in the 'rusher' column (NOTE: ids vary pre and post 2011 but are consistent for each player. Please see details for further information)}
\item{receiver_id}{ID of the player in the 'receiver' column (NOTE: ids vary pre and post 2011 but are consistent for each player. Please see details for further information)}
\item{name}{Name of the 'passer' if it is not 'NA', or name of the 'rusher' otherwise.}
\item{jersey_number}{Jersey number of the player listed in the 'name' column.}
\item{id}{ID of the player in the 'name' column (NOTE: ids vary pre and post 2011 but are consistent for each player. Please see details for further information)}
\item{qb_epa}{Gives QB credit for EPA for up to the point where a receiver lost a fumble after a completed catch and makes EPA work more like passing yards on plays with fumbles.}
}
}
\description{
Clean Play by Play Data
}
\details{
Build columns that capture what happens on all plays, including
penalties, using string extraction from play description.
Loosely based on Ben's nflfastR guide (\url{https://mrcaseb.github.io/nflfastR/articles/beginners_guide.html})
but updated to work with the RS data, which has a different player format in
the play description; e.g. 24-M.Lynch instead of M.Lynch.
The function also standardizes team abbreviations so that, for example,
the Chargers are always represented by 'LAC' regardless of which year it was.
The function also standardizes player IDs for players appearing in both the
older era (1999-2010) and the new era (2011+).
}
