% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/variance.R
\docType{methods}
\name{variance_total}
\alias{variance_total}
\alias{variance_total-method}
\alias{variance_total,CompositionMatrix-method}
\alias{variance_total,LogRatio-method}
\title{Total Variance}
\usage{
variance_total(x, ...)

\S4method{variance_total}{CompositionMatrix}(x, sd = FALSE)

\S4method{variance_total}{LogRatio}(x, row_weights = NULL, column_weights = TRUE)
}
\arguments{
\item{x}{A \code{\linkS4class{CompositionMatrix}} object.}

\item{...}{Currently not used.}

\item{sd}{A \code{\link{logical}} scalar: should the metric standard deviation be
returned instead of the metric variance?}

\item{row_weights}{A \code{\link{numeric}} vector of row weights. If \code{NULL} (the
default), equal weights are used.}

\item{column_weights}{A \code{\link{logical}} scalar: should the weights of the
log-ratio be used? If \code{FALSE}, equally-weighted parts are used.
Alternatively, a positive \code{\link{numeric}} vector of weights can be specified.}
}
\value{
A \code{\link{numeric}} vector.
}
\description{
Computes the total (or metric) variance, a global measure of spread.
}
\details{
Two methods are available, see below.
}
\section{Methods (by class)}{
\itemize{
\item \code{variance_total(CompositionMatrix)}: The total variance of compositional data is the
trace of the \link[=covariance]{centred log-ratio covariance} matrix
(i.e. \emph{totvar1} in Aitchison 1997).

\item \code{variance_total(LogRatio)}: Computes the total log-ratio variance. This is
identical to the weighted sum-of-squared distances between samples
(i.e. \emph{totvar2} in Aitchison 1997).

}}
\examples{
## Data from Aitchison 1986
data("hongite")

## Coerce to compositional data
coda <- as_composition(hongite)

## Total variance (1)
variance_total(coda)

## Metric standard deviation
variance_total(coda, sd = TRUE)

## CLR transformation
clr <- transform_clr(coda)

## Individual log-ratio variances
variance(clr)

## Total log-ratio variance (2)
variance_total(clr)

## Proportionality between (1) and (2)
## See Aitchison 1997
variance_total(coda) * (1 / ncol(coda)) * (1 - (1 / nrow(coda)))
}
\references{
Aitchison, J. (1986). \emph{The Statistical Analysis of Compositional Data}.
London: Chapman and Hall, p. 64-91.

Aitchison, J. (1997). The One-Hour Course in Compositional Data Analysis or
Compositional Data Analysis Is Simple. In V. Pawlowsky-Glahn (ed.),
\emph{IAMG'97}. Barcelona: International Center for Numerical Methods in
Engineering (CIMNE), p. 3-35.

Boogaart, K. G. van den & Tolosana-Delgado, R. (2013). \emph{Analyzing
Compositional Data with R}. Berlin Heidelberg: Springer-Verlag.
\doi{10.1007/978-3-642-36809-7}.

Greenacre, M. J. (2019). \emph{Compositional Data Analysis in Practice}.
Boca Raton: CRC Press.

Hron, K. & Kubáček. L. (2011). Statistical Properties of the Total Variation
Estimator for Compositional Data. \emph{Metrika}, 74 (2): 221-230.
\doi{10.1007/s00184-010-0299-3}.

Pawlowsky-Glahn, V. & Egozcue, J. J. (2001). Geometric Approach to
Statistical Analysis on the Simplex. \emph{Stochastic Environmental Research and
Risk Assessment}, 15(5): 384-398. \doi{10.1007/s004770100077}.
}
\seealso{
Other statistics: 
\code{\link{aggregate}()},
\code{\link{condense}()},
\code{\link{covariance}()},
\code{\link{dist}},
\code{\link{mahalanobis}()},
\code{\link{margin}()},
\code{\link{mean}()},
\code{\link{pip}()},
\code{\link{quantile}()},
\code{\link{scale}()},
\code{\link{variance}()},
\code{\link{variation}()}
}
\author{
N. Frerebeau
}
\concept{statistics}
