% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/replace.R
\docType{methods}
\name{missing}
\alias{missing}
\alias{replace_NA,CompositionMatrix-method}
\title{Missing Values Replacement}
\usage{
\S4method{replace_NA}{CompositionMatrix}(x, value)
}
\arguments{
\item{x}{A \code{\linkS4class{CompositionMatrix}} object.}

\item{value}{A \code{\link{numeric}} vector giving the replacement values.}
}
\value{
An \code{\linkS4class{CompositionMatrix}} object, where all missing values have been
replaced.
}
\description{
Multiplicative replacement of missing values.
}
\examples{
## Data from Martín-Fernández et al. 2003
X <- data.frame(
  X1 = c(0.0000, 0.1304, 0.1963),
  X2 = c(0.1250, 0.3151, NA),
  X3 = c(0.1237, NA, NA),
  X4 = c(0.7253, 0.2002, 0.0819),
  X5 = c(0.0260, 0.3543, 0.0114)
)

## Coerce to a compositional matrix
Y <- as_composition(X)

## Replace zeros
Z <- replace_NA(Y, value = 0.2)
Z
}
\references{
Martín-Fernández, J. A., Barceló-Vidal, C. & Pawlowsky-Glahn, V. (2003).
Dealing with Zeros and Missing Values in Compositional Data Sets Using
Nonparametric Imputation. \emph{Mathematical Geology}, 35(3): 253-278.
\doi{10.1023/A:1023866030544}.
}
\seealso{
Other imputation methods: 
\code{\link{policy}},
\code{\link{zero}}
}
\author{
N. Frerebeau
}
\concept{imputation methods}
