% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cards.R
\name{card}
\alias{card}
\title{Generate a flexible and extensible content container}
\usage{
card(
  ...,
  title = "Standard Card",
  collapsed = FALSE,
  bg.fade = TRUE,
  width = 12,
  alert.text = NULL,
  alert.bg = c("primary", "warning", "secondary", "info", "success", "danger"),
  toolbar = NULL,
  header = TRUE,
  draggable = TRUE
)
}
\arguments{
\item{...}{The elements to include within the body of the card}

\item{title}{The text to display in the header title}

\item{collapsed}{If \code{TRUE}, the card is collapsed. The default is \code{FALSE}}

\item{bg.fade}{If \code{TRUE}, the background will be faded if a background exists}

\item{width}{Select a width from 1 to 12 to indicate the size of the card}

\item{alert.text}{Enter text for the alert portion. Leave as NULL to exclude the alert}

\item{alert.bg}{Indicate the type of alert to include, choices are "primary", "warning", "secondary", "info", "success", "danger"}

\item{toolbar}{The default is NULL, which means all toolbar will be displayed use this to set what toolbar to show.}

\item{header}{If \code{FALSE}, the header will be excluded}

\item{draggable}{If \code{FALSE}, the card will not be draggable}
}
\value{
HTML code of the container with a class called card that holds the items
}
\description{
Widely used Bootstrap feature with improvements to allow collapse, minimize and closing
}
\note{
For more information on the features of the card, visit the examples section of the help documentation
}
\examples{
if (interactive()) {
 card(
   title = "Standard card",
   collapsed = TRUE,
   alert.text = "An alert for the content",
   alert.bg = "warning",
   toolbar = list(collapse = TRUE,
   maximize = TRUE, close = FALSE, menu = TRUE),
   shiny::h3("Sample text"),
   "Lorem ipsum dolor sit a"
 )
 }
}
