% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AllGeneric.R, R/BrainVolume.R
\docType{methods}
\name{writeVolume}
\alias{writeVolume}
\alias{writeVolume,BrainVolume,character,character,missing-method}
\alias{writeVolume,BrainVolume,character,missing,character-method}
\alias{writeVolume,BrainVolume,character,missing,missing-method}
\alias{writeVolume,ClusteredBrainVolume,character,missing,missing-method}
\title{Generic function to write a 3D image volume to disk}
\usage{
writeVolume(x, fileName, format, dataType)

\S4method{writeVolume}{BrainVolume,character,missing,missing}(x, fileName)

\S4method{writeVolume}{ClusteredBrainVolume,character,missing,missing}(x,
  fileName)

\S4method{writeVolume}{BrainVolume,character,character,missing}(x, fileName,
  format)

\S4method{writeVolume}{BrainVolume,character,missing,character}(x, fileName,
  dataType)
}
\arguments{
\item{x}{an image object, typically a \code{BrainVolume} instance.}

\item{fileName}{output file name}

\item{format}{file format string. Since "NIFTI" is the only currently supported format, this parameter can be safely ignored and omitted.}

\item{dataType}{output data type, If specified should be a \code{character} vector of: "BINARY", "UBYTE", "SHORT", "INT", "FLOAT", "DOUBLE".
Otherwise output format will be inferred from R the datatype of the image.}
}
\description{
Generic function to write a 3D image volume to disk
}
\details{
The output format will be inferred from file extension.
 \code{writeVolume(x, "out.nii")} outputs a NIFTI file.
 \code{writeVolume(x, "out.nii.gz")} outputs a gzipped NIFTI file.

No other file output formats are currently supported.
}
\examples{
bvol <- BrainVolume(array(0, c(10,10,10)), BrainSpace(c(10,10,10), c(1,1,1)))
\dontrun{
writeVolume(bvol, "out.nii")
writeVolume(bvol, "out.nii.gz")
}
}

