% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AllGeneric.R, R/BrainSpace.R
\docType{methods}
\name{addDim}
\alias{addDim}
\alias{addDim,BrainSpace,numeric-method}
\title{Generic function to add a dimension to an object}
\usage{
addDim(x, n)

\S4method{addDim}{BrainSpace,numeric}(x, n)
}
\arguments{
\item{x}{a dimensioned object}

\item{n}{the size of the dimension to add}
}
\description{
Generic function to add a dimension to an object

add dimension to \code{\linkS4class{BrainSpace}}
}
\examples{
x = BrainSpace(c(10,10,10), c(1,1,1))
x1 <- addDim(x, 10)
ndim(x1) == 4
dim(x1)[4] == 10
}

